/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.core.monitor;

import ie.ucd.sixth.core.IReceiver;
import ie.ucd.sixth.core.adaptor.AdaptorInformation;
import ie.ucd.sixth.core.receiver.IAdaptorReceiver;
import ie.ucd.sixth.core.receiver.ICredentialedReceiver;
import ie.ucd.sixth.core.receiver.IEventReceiver;
import ie.ucd.sixth.core.receiver.INodeReceiver;
import ie.ucd.sixth.core.receiver.IRetaskingReceiver;
import ie.ucd.sixth.core.sensor.NodeDescription;
import ie.ucd.sixth.core.sensor.SensorDescription;
import java.util.List;
import java.util.Vector;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class DiscoveryReceiverMonitor {
    private List<IEventReceiver> eventReceivers = new Vector<IEventReceiver>();
    private List<IAdaptorReceiver> adaptorReceivers = new Vector<IAdaptorReceiver>();
    private List<INodeReceiver> moteReceivers = new Vector<INodeReceiver>();
    private List<IRetaskingReceiver> retaskingReceivers = new Vector<IRetaskingReceiver>();
    private List<IReceiver> receivers = new Vector<IReceiver>();
    private static DiscoveryReceiverMonitor instance;

    public static DiscoveryReceiverMonitor getMonitor(BundleContext context) {
        if (instance == null) {
            instance = new DiscoveryReceiverMonitor(context);
        }
        return instance;
    }

    private DiscoveryReceiverMonitor(final BundleContext context) {
        ServiceTracker eventTracker = new ServiceTracker(context, IEventReceiver.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<IEventReceiver, IEventReceiver>(){

            public IEventReceiver addingService(ServiceReference<IEventReceiver> sr) {
                IEventReceiver dataReceiver = (IEventReceiver)context.getService(sr);
                DiscoveryReceiverMonitor.this.eventReceivers.add(dataReceiver);
                DiscoveryReceiverMonitor.this.alertReceivers(dataReceiver);
                return dataReceiver;
            }

            public void modifiedService(ServiceReference<IEventReceiver> sr, IEventReceiver s) {
            }

            public void removedService(ServiceReference<IEventReceiver> sr, IEventReceiver s) {
                DiscoveryReceiverMonitor.this.eventReceivers.remove(s);
            }
        });
        eventTracker.open();
        ServiceTracker adaptorTracker = new ServiceTracker(context, IAdaptorReceiver.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<IAdaptorReceiver, IAdaptorReceiver>(){

            public IAdaptorReceiver addingService(ServiceReference<IAdaptorReceiver> sr) {
                IAdaptorReceiver dataReceiver = (IAdaptorReceiver)context.getService(sr);
                DiscoveryReceiverMonitor.this.adaptorReceivers.add(dataReceiver);
                DiscoveryReceiverMonitor.this.alertReceivers(dataReceiver);
                return dataReceiver;
            }

            public void modifiedService(ServiceReference<IAdaptorReceiver> sr, IAdaptorReceiver s) {
            }

            public void removedService(ServiceReference<IAdaptorReceiver> sr, IAdaptorReceiver s) {
                DiscoveryReceiverMonitor.this.adaptorReceivers.remove(s);
            }
        });
        adaptorTracker.open();
        ServiceTracker moteTracker = new ServiceTracker(context, INodeReceiver.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<INodeReceiver, INodeReceiver>(){

            public INodeReceiver addingService(ServiceReference<INodeReceiver> sr) {
                INodeReceiver dataReceiver = (INodeReceiver)context.getService(sr);
                DiscoveryReceiverMonitor.this.moteReceivers.add(dataReceiver);
                DiscoveryReceiverMonitor.this.alertReceivers(dataReceiver);
                return dataReceiver;
            }

            public void modifiedService(ServiceReference<INodeReceiver> sr, INodeReceiver s) {
            }

            public void removedService(ServiceReference<INodeReceiver> sr, INodeReceiver s) {
                DiscoveryReceiverMonitor.this.moteReceivers.remove(s);
            }
        });
        moteTracker.open();
        ServiceTracker retaskingTracker = new ServiceTracker(context, IRetaskingReceiver.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<IRetaskingReceiver, IRetaskingReceiver>(){

            public IRetaskingReceiver addingService(ServiceReference<IRetaskingReceiver> sr) {
                IRetaskingReceiver dataReceiver = (IRetaskingReceiver)context.getService(sr);
                DiscoveryReceiverMonitor.this.retaskingReceivers.add(dataReceiver);
                DiscoveryReceiverMonitor.this.alertReceivers(dataReceiver);
                return dataReceiver;
            }

            public void modifiedService(ServiceReference<IRetaskingReceiver> sr, IRetaskingReceiver s) {
            }

            public void removedService(ServiceReference<IRetaskingReceiver> sr, IRetaskingReceiver s) {
                DiscoveryReceiverMonitor.this.retaskingReceivers.remove(s);
            }
        });
        retaskingTracker.open();
    }

    public void addReceiver(IReceiver receiver) {
        this.receivers.add(receiver);
    }

    private void alertReceivers(ICredentialedReceiver receiver) {
        for (IReceiver rec : this.receivers) {
            rec.receive(receiver);
        }
    }

    public List<IEventReceiver> getEventReceivers() {
        return this.eventReceivers;
    }

    public List<INodeReceiver> getNodeReceivers() {
        return this.moteReceivers;
    }

    public void notify(NodeDescription desc, String string) {
        for (INodeReceiver receiver : this.moteReceivers) {
            receiver.receive(desc, string);
        }
    }

    public void notify(SensorDescription readObject, String status) {
        for (INodeReceiver receiver : this.moteReceivers) {
            receiver.receive(readObject, status);
        }
    }

    public void notify(AdaptorInformation info, String event) {
        for (IAdaptorReceiver receiver : this.adaptorReceivers) {
            receiver.receive(info, event);
        }
    }

    public void notify(String event) {
        for (IEventReceiver receiver : this.eventReceivers) {
            receiver.receive(event);
        }
    }
}

