/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.core.discovery;

import ie.ucd.sixth.core.Activator;
import ie.ucd.sixth.core.adaptor.AdaptorInformation;
import ie.ucd.sixth.core.adaptor.IAdaptor;
import ie.ucd.sixth.core.adaptor.ISensorAdaptor;
import ie.ucd.sixth.core.discovery.IDiscovery;
import ie.ucd.sixth.core.discovery.ISIXTHNode;
import ie.ucd.sixth.core.receiver.IAdaptorReceiver;
import ie.ucd.sixth.core.sensor.ISensorNode;
import ie.ucd.sixth.core.service.IPipeAdaptor;
import ie.ucd.sixth.core.service.IServiceFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class SIXTHNode
implements ISIXTHNode,
IAdaptorReceiver {
    private Map<String, ISensorAdaptor> sensorAdaptors = new HashMap<String, ISensorAdaptor>();
    private Map<String, IPipeAdaptor> pipeAdaptors = new HashMap<String, IPipeAdaptor>();
    private Map<String, IAdaptor> adaptors = new HashMap<String, IAdaptor>();
    private Map<String, IServiceFactory> serviceFactories = new HashMap<String, IServiceFactory>();
    private IDiscovery discovery;
    private String name;

    public SIXTHNode(IDiscovery discovery, String string) {
        this.discovery = discovery;
        this.name = string;
        Activator.getContext().registerService(IAdaptorReceiver.class, (Object)this, null);
    }

    @Override
    public List<ISensorAdaptor> getSensorAdaptors() {
        return new Vector<ISensorAdaptor>(this.sensorAdaptors.values());
    }

    @Override
    public ISensorAdaptor getSensorAdaptor(String type) {
        return this.sensorAdaptors.get(type);
    }

    @Override
    public List<IPipeAdaptor> getPipeAdaptors() {
        return new Vector<IPipeAdaptor>(this.pipeAdaptors.values());
    }

    @Override
    public IPipeAdaptor getPipeAdaptor(String type) {
        return this.pipeAdaptors.get(type);
    }

    @Override
    public List<IServiceFactory> getServiceFactories() {
        return new Vector<IServiceFactory>(this.serviceFactories.values());
    }

    @Override
    public IServiceFactory getServiceFactory(String type) {
        return this.serviceFactories.get(type);
    }

    @Override
    public List<IAdaptor> getAdaptors() {
        return new ArrayList<IAdaptor>(this.adaptors.values());
    }

    @Override
    public IAdaptor getAdaptor(String type) {
        return this.adaptors.get(type);
    }

    @Override
    public void registerAdaptor(IAdaptor adaptor) {
        adaptor.attachNode(this);
        this.adaptors.put(adaptor.getType(), adaptor);
        if (adaptor instanceof IServiceFactory) {
            IServiceFactory serviceAdaptor = (IServiceFactory)adaptor;
            System.err.println("[Discovery] Registered:" + adaptor);
            this.serviceFactories.put(adaptor.getType(), serviceAdaptor);
        }
        if (adaptor instanceof ISensorAdaptor) {
            ISensorAdaptor sensorAdaptor = (ISensorAdaptor)adaptor;
            System.err.println("[Discovery] Registered:" + adaptor);
            this.sensorAdaptors.put(adaptor.getInfo().getName(), sensorAdaptor);
            for (ISensorNode sensor : sensorAdaptor.getNodes()) {
                this.discovery.getNodeDiscovery().addNode(sensor);
            }
        }
        if (adaptor instanceof IPipeAdaptor) {
            IPipeAdaptor pipeAdaptor = (IPipeAdaptor)adaptor;
            System.err.println("[Discovery] Registered:" + adaptor);
            this.pipeAdaptors.put(adaptor.getInfo().getName(), pipeAdaptor);
        }
    }

    @Override
    public String getCredentials() {
        return "pass";
    }

    @Override
    public void unregister() {
    }

    @Override
    public void receive(AdaptorInformation info, String event) {
        String type = info.getAdaptorType();
        if (event.equals("unregistering")) {
            if (type.equals("SERVICE_ADAPTOR")) {
                this.serviceFactories.remove(info.getAddress());
            } else if (type.equals("SENSOR_ADAPTOR")) {
                this.sensorAdaptors.remove(info.getAddress());
            }
            this.adaptors.remove(info.getAddress());
        }
    }

    @Override
    public String getAddress() {
        return this.name;
    }
}

