/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.core.discovery;

import ie.ucd.sixth.core.IRetensionPolicy;
import ie.ucd.sixth.core.adaptor.ISensorAdaptor;
import ie.ucd.sixth.core.sensor.ISensor;
import ie.ucd.sixth.core.sensor.ISensorNode;

public class RetentionPolicyManager
extends Thread {
    private ISensorAdaptor adaptor;
    private long interval;
    private boolean active = false;
    private IRetensionPolicy retentionPolicy;

    public RetentionPolicyManager(ISensorAdaptor adaptor, IRetensionPolicy policy, long interval) {
        this.retentionPolicy = policy;
        this.adaptor = adaptor;
        this.interval = interval;
        this.active = true;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.active) {
            ISensorAdaptor iSensorAdaptor = this.adaptor;
            synchronized (iSensorAdaptor) {
                this.adaptor.visit(this.retentionPolicy);
                for (ISensorNode node : this.adaptor.getNodes()) {
                    for (ISensor sensor : node.getSensors()) {
                        sensor.visit(this.retentionPolicy);
                    }
                }
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void changePolicy(IRetensionPolicy retensionPolicy) {
        this.retentionPolicy = retensionPolicy;
    }
}

