/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.core.discovery;

import ie.ucd.sixth.core.RetaskingMsg;
import ie.ucd.sixth.core.adaptor.AdaptorInformation;
import ie.ucd.sixth.core.adaptor.ISensorAdaptor;
import ie.ucd.sixth.core.discovery.IDiscovery;
import ie.ucd.sixth.core.discovery.IRetaskingService;
import ie.ucd.sixth.core.service.IPipeAdaptor;
import ie.ucd.sixth.core.service.IServiceFactory;

public class RetaskingService
implements IRetaskingService {
    private IDiscovery discovery;
    private boolean log;

    public RetaskingService(IDiscovery discovery) {
        this.discovery = discovery;
    }

    @Override
    public boolean retask(RetaskingMsg message) {
        AdaptorInformation info = message.getAdaptor();
        if (this.log) {
            System.out.println(message);
        }
        if (info.getAdaptorType().equals("SENSOR_ADAPTOR")) {
            ISensorAdaptor adaptor = this.discovery.getLocalNode().getSensorAdaptor(info.getName());
            boolean ret = adaptor.retask(message);
            return ret;
        }
        if (info.getAdaptorType().equals("SERVICE_ADAPTOR")) {
            IServiceFactory adaptor = this.discovery.getLocalNode().getServiceFactory(info.getName());
            boolean ret = adaptor.retask(message);
            return ret;
        }
        if (info.getAdaptorType().equals("PIPE_ADAPTOR")) {
            IPipeAdaptor adaptor = this.discovery.getLocalNode().getPipeAdaptor(info.getName());
            boolean ret = adaptor.retask(message);
            return ret;
        }
        return false;
    }

    @Override
    public void log(boolean log) {
        this.log = log;
    }
}

