/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.core.discovery;

import ie.ucd.sixth.core.discovery.INodeDiscovery;
import ie.ucd.sixth.core.query.IQuery;
import ie.ucd.sixth.core.query.SensorDataQuery;
import ie.ucd.sixth.core.query.SensorDescriptionQuery;
import ie.ucd.sixth.core.sensor.ISensorNode;
import ie.ucd.sixth.core.sensor.NodeDescription;
import ie.ucd.sixth.core.sensor.data.ISensorData;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class NodeDiscovery
implements INodeDiscovery {
    private List<ISensorNode> sensors = new Vector<ISensorNode>();

    @Override
    public void addNode(ISensorNode sensor) {
        this.sensors.add(sensor);
    }

    @Override
    public <T> List<T> getNodes(Class<T> class1) {
        Vector<ISensorNode> matches = new Vector<ISensorNode>();
        for (ISensorNode sensor : this.sensors) {
            if (sensor.getClass() != class1) continue;
            matches.add(sensor);
        }
        return matches;
    }

    @Override
    public List<NodeDescription> getNodeDescriptions(IQuery query) {
        Vector<NodeDescription> descriptions = new Vector<NodeDescription>();
        for (ISensorNode sensor : this.sensors) {
            if (!query.match(sensor)) continue;
            descriptions.add(sensor.getDescription());
        }
        return descriptions;
    }

    @Override
    public List<NodeDescription> getNodeDescriptions() {
        Vector<NodeDescription> descriptions = new Vector<NodeDescription>();
        for (ISensorNode sensor : this.sensors) {
            descriptions.add(sensor.getDescription());
        }
        return descriptions;
    }

    @Override
    public boolean nodeExists(int id) {
        for (ISensorNode sensor : this.sensors) {
            if (sensor.getID() != id) continue;
            return true;
        }
        return false;
    }

    @Override
    public ISensorNode getNode(NodeDescription description) {
        SensorDescriptionQuery query = new SensorDescriptionQuery(description);
        List<ISensorNode> list = this.getNodes(query);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public List<ISensorNode> getNodes() {
        return this.sensors;
    }

    @Override
    public List<ISensorNode> getNodes(IQuery query) {
        return query.matches(this.sensors);
    }

    public List<ISensorData> getCorrelatedData(ISensorData data, Map<String, String> criteria) {
        SensorDataQuery query = new SensorDataQuery(data, criteria);
        Vector<ISensorData> list = new Vector<ISensorData>();
        for (ISensorNode sensor : this.sensors) {
            Map<String, List<ISensorData>> readings = sensor.getReadings();
            for (String key : readings.keySet()) {
                List<ISensorData> temp = readings.get(key);
                list.addAll(query.matchesData(temp));
            }
        }
        return list;
    }
}

