/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.core.discovery;

import ie.ucd.sixth.core.adaptor.AdaptorInformation;
import ie.ucd.sixth.core.adaptor.IAdaptor;
import ie.ucd.sixth.core.discovery.AdaptorAccess;
import ie.ucd.sixth.core.discovery.DataAccessService;
import ie.ucd.sixth.core.discovery.IAdaptorAccess;
import ie.ucd.sixth.core.discovery.IDataAccess;
import ie.ucd.sixth.core.discovery.IDiscovery;
import ie.ucd.sixth.core.discovery.INodeDiscovery;
import ie.ucd.sixth.core.discovery.IRetaskingService;
import ie.ucd.sixth.core.discovery.ISIXTHNode;
import ie.ucd.sixth.core.discovery.NodeDiscovery;
import ie.ucd.sixth.core.discovery.RetaskingService;
import ie.ucd.sixth.core.discovery.SIXTHNode;
import java.util.HashMap;
import java.util.Map;

public final class Discovery
implements IDiscovery {
    private INodeDiscovery nodeAccess;
    private IDataAccess dataAccess;
    private IAdaptorAccess adaptorAccess;
    private IRetaskingService retasking;
    private ISIXTHNode localNode;
    private Map<String, ISIXTHNode> nodes = new HashMap<String, ISIXTHNode>();

    public Discovery() {
        this.nodeAccess = new NodeDiscovery();
        this.adaptorAccess = new AdaptorAccess(this);
        this.dataAccess = new DataAccessService(this);
        this.retasking = new RetaskingService(this);
        this.localNode = new SIXTHNode(this, "localhost");
        this.nodes.put(this.localNode.getAddress(), this.localNode);
    }

    @Override
    public void registerAdaptor(IAdaptor adaptor) {
        AdaptorInformation info = adaptor.getInfo();
        if (info.isLocal()) {
            this.localNode.registerAdaptor(adaptor);
        }
    }

    @Override
    public INodeDiscovery getNodeDiscovery() {
        return this.nodeAccess;
    }

    @Override
    public IRetaskingService getRetaskingService() {
        return this.retasking;
    }

    @Override
    public Map<String, ISIXTHNode> getSIXTHNodes() {
        return this.nodes;
    }

    @Override
    public ISIXTHNode getLocalNode() {
        return this.localNode;
    }

    @Override
    public IDataAccess getDataAccess() {
        return this.dataAccess;
    }

    @Override
    public IAdaptorAccess getAdaptorAccess() {
        return this.adaptorAccess;
    }
}

