/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.core.discovery;

import ie.ucd.sixth.core.adaptor.ISensorAdaptor;
import ie.ucd.sixth.core.discovery.IDataAccess;
import ie.ucd.sixth.core.discovery.IDiscovery;
import ie.ucd.sixth.core.discovery.ISIXTHNode;
import ie.ucd.sixth.core.query.IQuery;
import ie.ucd.sixth.core.query.MalformedQueryException;
import ie.ucd.sixth.core.query.QueryFactory;
import ie.ucd.sixth.core.sensor.data.ISensorData;
import java.util.Collection;
import java.util.List;
import java.util.Vector;

public class DataAccessService
implements IDataAccess {
    private IDiscovery discovery;

    public DataAccessService(IDiscovery discovery) {
        this.discovery = discovery;
    }

    @Override
    public List<ISensorData> getAllData() {
        Vector<ISensorData> data = new Vector<ISensorData>();
        Collection<ISIXTHNode> nodes = this.discovery.getSIXTHNodes().values();
        for (ISIXTHNode isixthNode : nodes) {
            List<ISensorAdaptor> sensorAdaptors = isixthNode.getSensorAdaptors();
            for (ISensorAdaptor iSensorAdaptor : sensorAdaptors) {
                data.addAll(iSensorAdaptor.getSensorData());
            }
        }
        return data;
    }

    @Override
    public List<ISensorData> getAllData(IQuery query) {
        return query.matchesData(this.getAllData());
    }

    @Override
    public List<ISensorData> getAllData(String query) throws MalformedQueryException {
        IQuery generated = QueryFactory.getInstance(query);
        return this.getAllData(generated);
    }
}

