/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.core.discovery;

import ie.ucd.sixth.core.adaptor.ISensorAdaptor;
import ie.ucd.sixth.core.discovery.IAdaptorAccess;
import ie.ucd.sixth.core.discovery.IDiscovery;
import ie.ucd.sixth.core.discovery.ISIXTHNode;
import ie.ucd.sixth.core.service.IPipeAdaptor;
import ie.ucd.sixth.core.service.IServiceFactory;
import java.util.ArrayList;
import java.util.List;

public class AdaptorAccess
implements IAdaptorAccess {
    private IDiscovery discovery;

    public AdaptorAccess(IDiscovery discovery) {
        this.discovery = discovery;
    }

    @Override
    public List<ISensorAdaptor> getSensorAdaptors(String name) {
        ArrayList<ISensorAdaptor> list = new ArrayList<ISensorAdaptor>();
        for (ISIXTHNode node : this.discovery.getSIXTHNodes().values()) {
            for (ISensorAdaptor adaptor : node.getSensorAdaptors()) {
                if (!adaptor.getInfo().getName().equals(name)) continue;
                list.add(adaptor);
            }
        }
        return list;
    }

    @Override
    public List<IServiceFactory> getServiceAdaptors(String name) {
        ArrayList<IServiceFactory> list = new ArrayList<IServiceFactory>();
        for (ISIXTHNode node : this.discovery.getSIXTHNodes().values()) {
            for (IServiceFactory adaptor : node.getServiceFactories()) {
                if (!adaptor.getInfo().getName().equals(name)) continue;
                list.add(adaptor);
            }
        }
        return list;
    }

    @Override
    public List<ISensorAdaptor> getSensorAdaptors() {
        ArrayList<ISensorAdaptor> list = new ArrayList<ISensorAdaptor>();
        for (ISIXTHNode node : this.discovery.getSIXTHNodes().values()) {
            list.addAll(node.getSensorAdaptors());
        }
        return list;
    }

    @Override
    public List<IServiceFactory> getServiceAdaptors() {
        ArrayList<IServiceFactory> list = new ArrayList<IServiceFactory>();
        for (ISIXTHNode node : this.discovery.getSIXTHNodes().values()) {
            list.addAll(node.getServiceFactories());
        }
        return list;
    }

    @Override
    public List<IPipeAdaptor> getPipeAdaptors() {
        ArrayList<IPipeAdaptor> list = new ArrayList<IPipeAdaptor>();
        for (ISIXTHNode node : this.discovery.getSIXTHNodes().values()) {
            list.addAll(node.getPipeAdaptors());
        }
        return list;
    }

    @Override
    public List<IPipeAdaptor> getPipeAdaptors(String name) {
        ArrayList<IPipeAdaptor> list = new ArrayList<IPipeAdaptor>();
        for (ISIXTHNode node : this.discovery.getSIXTHNodes().values()) {
            for (IPipeAdaptor adaptor : node.getPipeAdaptors()) {
                if (!adaptor.getInfo().getName().equals(name)) continue;
                list.add(adaptor);
            }
        }
        return list;
    }
}

