/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.core.databroker;

import ie.ucd.sixth.core.databroker.DefaultDataBroker;
import ie.ucd.sixth.core.databroker.IQueryDataReceiver;
import ie.ucd.sixth.core.query.IQuery;
import ie.ucd.sixth.core.query.IRealTimeQuery;
import ie.ucd.sixth.core.sensor.data.ISensorData;
import java.util.Timer;
import java.util.TimerTask;

public class RealTimeDataReceiver
implements IQueryDataReceiver {
    private IRealTimeQuery query;
    private DefaultDataBroker broker;
    private int samples;
    private Timer timer;
    private boolean timed;
    private IQueryDataReceiver receiver;

    public RealTimeDataReceiver(IRealTimeQuery query, IQueryDataReceiver receiver, DefaultDataBroker dataBroker) {
        this.query = query;
        this.receiver = receiver;
        this.broker = dataBroker;
        this.samples = 0;
        this.timer = new Timer();
        boolean bl = this.timed = query.getDuration() != null && query.getDuration().isTimeBased();
        if (this.timed) {
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    RealTimeDataReceiver.this.halt();
                }
            }, query.getDuration().getMillis());
        }
    }

    @Override
    public void receive(ISensorData data, IQuery query) {
        assert (query == this.query);
        this.receiver.receive(data, query);
        ++this.samples;
        if (!this.timed && this.samples > this.query.getDuration().getSampleSize()) {
            this.halt();
        }
    }

    @Override
    public void receive(String notification, IQuery query) {
        assert (query == this.query);
        this.receiver.receive(notification, query);
    }

    private void halt() {
        this.timer.cancel();
        this.timer = null;
    }
}

