/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.core.databroker;

import ie.ucd.sixth.core.Activator;
import ie.ucd.sixth.core.databroker.IDataBroker;
import ie.ucd.sixth.core.databroker.IQueryDataReceiver;
import ie.ucd.sixth.core.databroker.RealTimeDataReceiver;
import ie.ucd.sixth.core.monitor.DataReceiverMonitor;
import ie.ucd.sixth.core.query.IQuery;
import ie.ucd.sixth.core.query.IRealTimeQuery;
import ie.ucd.sixth.core.receiver.IDataReceiver;
import ie.ucd.sixth.core.sensor.data.ISensorData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DefaultDataBroker
implements IDataBroker {
    private Map<IQuery, IQueryDataReceiver> map = new HashMap<IQuery, IQueryDataReceiver>();
    private static DataReceiverMonitor dataReceiverMonitor = DataReceiverMonitor.getMonitor(Activator.getContext());

    @Override
    public void registerInterest(IQuery query, IQueryDataReceiver receiver) {
        if (query instanceof IRealTimeQuery) {
            this.map.put(query, new RealTimeDataReceiver((IRealTimeQuery)query, receiver, this));
        } else {
            this.map.put(query, receiver);
        }
    }

    @Override
    public void unregisterInterest(IQuery query) {
        this.map.remove(query);
    }

    @Override
    public void send(ISensorData data) {
        for (IQuery q : this.map.keySet()) {
            if (!q.match(data)) continue;
            this.map.get(q).receive(data, q);
        }
        for (IDataReceiver receiver : new ArrayList<IDataReceiver>(dataReceiverMonitor.getDataReceviers())) {
            receiver.receive(data);
        }
    }

    @Override
    public void notifyActive() {
    }

    @Override
    public void notifyInactive() {
    }
}

