/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.core.adaptor;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class AdaptorInformation
implements Serializable {
    public static final String SENSOR_ADAPTOR = "SENSOR_ADAPTOR";
    public static final String SERVICE_FACTORY = "SERVICE_ADAPTOR";
    public static final String PIPE_ADAPTOR = "PIPE_ADAPTOR";
    private static final long serialVersionUID = -6837425531432598426L;
    private InetAddress address;
    private String adaptorName;
    private String adaptorType;
    private boolean local = true;
    private String state = "";
    private String spec;

    public AdaptorInformation(String name, String type) {
        this.adaptorName = name;
        this.adaptorType = type;
        try {
            this.setAddress(InetAddress.getLocalHost());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public AdaptorInformation(InetAddress ip, String name) {
        this.adaptorName = name;
        this.address = ip;
        this.local = false;
    }

    public AdaptorInformation(AdaptorInformation info) {
        this.adaptorName = info.getName();
        this.address = info.getAddress();
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public String getName() {
        return this.adaptorName;
    }

    public String toString() {
        return (String.valueOf(this.adaptorName) + " " + this.adaptorType).toUpperCase();
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public String getSpec() {
        return this.spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getAdaptorType() {
        return this.adaptorType;
    }

    public void setAdaptorType(String adaptorType) {
        this.adaptorType = adaptorType;
    }

    public boolean isLocal() {
        return this.local;
    }

    public boolean equals(Object object) {
        if (object instanceof AdaptorInformation) {
            AdaptorInformation information = (AdaptorInformation)object;
            return this.adaptorName.equals(information.adaptorName);
        }
        return false;
    }
}

