/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.core.adaptor;

import ie.ucd.sixth.core.DataRetensionPolicy;
import ie.ucd.sixth.core.Frequency;
import ie.ucd.sixth.core.IRetensionPolicy;
import ie.ucd.sixth.core.RetaskingMsg;
import ie.ucd.sixth.core.SIXTH;
import ie.ucd.sixth.core.SensorStatus;
import ie.ucd.sixth.core.adaptor.AdaptorInformation;
import ie.ucd.sixth.core.adaptor.ISensorAdaptor;
import ie.ucd.sixth.core.application.IApplication;
import ie.ucd.sixth.core.discovery.IDiscovery;
import ie.ucd.sixth.core.discovery.IDiscoveryHandler;
import ie.ucd.sixth.core.discovery.ISIXTHNode;
import ie.ucd.sixth.core.discovery.RetentionPolicyManager;
import ie.ucd.sixth.core.monitor.DiscoveryReceiverMonitor;
import ie.ucd.sixth.core.monitor.RetaskingReceiverMonitor;
import ie.ucd.sixth.core.query.IQuery;
import ie.ucd.sixth.core.receiver.IAdaptorReceiver;
import ie.ucd.sixth.core.receiver.ICredentialedReceiver;
import ie.ucd.sixth.core.receiver.INodeReceiver;
import ie.ucd.sixth.core.receiver.IRetaskingReceiver;
import ie.ucd.sixth.core.sensor.ISensor;
import ie.ucd.sixth.core.sensor.ISensorNode;
import ie.ucd.sixth.core.sensor.NodeDescription;
import ie.ucd.sixth.core.sensor.SensorDescription;
import ie.ucd.sixth.core.sensor.SensorNode;
import ie.ucd.sixth.core.sensor.data.ISensorData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;

public abstract class AbstractSensorAdaptor
implements ISensorAdaptor {
    private static final Logger log = Logger.getLogger("SIXTH.CORE");
    private long timeout;
    protected BundleContext context;
    protected IDiscovery discovery;
    protected Map<Integer, ISensorNode> sensors = new HashMap<Integer, ISensorNode>();
    protected List<IApplication> applications;
    protected boolean registered = false;
    protected Timer timer;
    protected AdaptorInformation information;
    protected DiscoveryReceiverMonitor discoveryReceiverFinder;
    private List<RetaskingMsg.COMMANDTYPE> commandList = new Vector<RetaskingMsg.COMMANDTYPE>();
    private List<ISensorData> sensorData = new Vector<ISensorData>();
    private RetaskingReceiverMonitor retaskingReceiverMonitor;
    private RetentionPolicyManager retentionPolicyManager;
    private ISIXTHNode node;

    static {
        log.setLevel(Level.OFF);
    }

    public AbstractSensorAdaptor(BundleContext bundleContext, String type) {
        this.init(bundleContext, type);
    }

    protected void init(BundleContext bundleContext, String type) {
        this.context = bundleContext;
        this.information = new AdaptorInformation(type, "SENSOR_ADAPTOR");
        this.information.setSpec(this.getSpecification());
        this.initReceiverManagement();
        this.initCommandList();
        this.configureTimer();
        this.retentionPolicyManager = new RetentionPolicyManager(this, new DataRetensionPolicy(), 5000L);
        this.discoveryRegistration();
    }

    private void initCommandList() {
        this.commandList.add(RetaskingMsg.COMMANDTYPE.REQUESTFREQ);
        this.commandList.add(RetaskingMsg.COMMANDTYPE.REQUESTVALUE);
        this.commandList.add(RetaskingMsg.COMMANDTYPE.RETASK);
        this.commandList.add(RetaskingMsg.COMMANDTYPE.SETFREQ);
    }

    private void initReceiverManagement() {
        this.discoveryReceiverFinder = DiscoveryReceiverMonitor.getMonitor(this.context);
        this.discoveryReceiverFinder.addReceiver(this);
        this.applications = SIXTH.get(IApplication.class, this.context);
        this.retaskingReceiverMonitor = RetaskingReceiverMonitor.getMonitor(this.context);
    }

    protected void configureTimer() {
        this.timer = new Timer();
    }

    @Override
    public void receive(ICredentialedReceiver receiver) {
        log.info("Added new Discovery Receiver: " + receiver);
        if (receiver instanceof IAdaptorReceiver) {
            ((IAdaptorReceiver)receiver).receive(this.getInfo(), "Unchanged");
        }
        if (receiver instanceof INodeReceiver) {
            INodeReceiver moteReceiver = (INodeReceiver)receiver;
            for (ISensorNode sensorNode : this.sensors.values()) {
                moteReceiver.receive(sensorNode, SensorStatus.ON.toString());
                for (ISensor sensor : sensorNode.getSensors()) {
                    moteReceiver.receive(sensor, SensorStatus.ON.toString());
                }
            }
        }
    }

    protected void send(ISensorData data) {
        SIXTH.getDataBroker(this.context).send(data);
    }

    protected void discoveryRegistration() {
        IDiscoveryHandler handler = SIXTH.getDiscoveryHandler();
        this.discovery = handler.getDiscovery("pass");
        this.discovery.registerAdaptor(this);
        this.discoveryReceiverFinder.notify(this.getInfo(), "New Adaptor");
    }

    protected List<IApplication> getApplications() {
        return this.applications;
    }

    protected void handleRegistration(byte id, String key, long time) {
        Vector<Map<String, Frequency>> requirements = new Vector<Map<String, Frequency>>();
        NodeDescription desc = null;
        for (IApplication app : this.getApplications()) {
            requirements.add(app.getRequirements(desc));
        }
    }

    protected ISensorNode nodeLookup(NodeDescription id) {
        int sensorID = id.getID();
        ISensorNode sensor = this.sensors.get(sensorID);
        if (this.sensors.get(sensorID) == null) {
            sensor = new SensorNode(id, this);
            this.sensors.put(sensorID, sensor);
            this.sendToReceivers(sensor, SensorStatus.NEW.toString());
            if (this.discovery != null) {
                this.discovery.getNodeDiscovery().addNode(sensor);
            }
        }
        return sensor;
    }

    @Override
    public List<ISensorNode> getNodes() {
        return new Vector<ISensorNode>(this.sensors.values());
    }

    public String toString() {
        return this.information.toString();
    }

    @Override
    public String getType() {
        return this.information.getAdaptorType();
    }

    @Override
    public void notifyTimeout(ISensorNode sensor) {
        this.sendToReceivers(sensor, SensorStatus.TIMEOUT.toString());
    }

    @Override
    public boolean credentialsSatisfy(String pass) {
        return true;
    }

    @Override
    public void unregister() {
        this.discoveryReceiverFinder.notify(this.getInfo(), "unregistering");
    }

    @Override
    public AdaptorInformation getInfo() {
        return this.information;
    }

    protected void informRetaskingListeners(RetaskingMsg message) {
        message.setAdaptor(this.getInfo());
        for (IRetaskingReceiver listener : this.retaskingReceiverMonitor.getRetaskingReceviers()) {
            listener.receive(message);
        }
    }

    @Override
    public void addSensor(ISensor sensor) {
        this.sendToReceivers(sensor, SensorStatus.NEW.toString());
    }

    protected void sendToReceivers(ISensor sensor, String type) {
        for (INodeReceiver receiver : this.discoveryReceiverFinder.getNodeReceivers()) {
            if ("pass".equals(receiver.getCredentials())) {
                receiver.receive(sensor, type);
                continue;
            }
            receiver.receive(sensor.getDescription(), type);
        }
    }

    protected void sendToReceivers(ISensorNode sensor, String type) {
        for (INodeReceiver receiver : this.discoveryReceiverFinder.getNodeReceivers()) {
            if ("pass".equals(receiver.getCredentials())) {
                receiver.receive(sensor, type);
                continue;
            }
            receiver.receive(sensor.getDescription(), type);
        }
    }

    @Override
    public void notifyChange(ISensorNode sensor) {
        this.sendToReceivers(sensor, sensor.getState());
    }

    @Override
    public void notifyChange(SensorDescription readObject) {
        for (INodeReceiver receiver : this.discoveryReceiverFinder.getNodeReceivers()) {
            receiver.receive(readObject, "Lols");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addData(ISensorData data) {
        int id = data.getID();
        String sensedModality = data.getSensedModality();
        ISensorNode node = this.nodeLookup(new NodeDescription(id, this.getType()));
        data.setDescription(node.getDescription());
        ISensor sensor = node.sensorLookup(new SensorDescription(sensedModality, id, this.getType()));
        sensor.addData(data);
        this.send(data);
        List<ISensorData> list = this.sensorData;
        synchronized (list) {
            this.sensorData.add(data);
        }
    }

    @Override
    public List<RetaskingMsg.COMMANDTYPE> acceptedCommands() {
        return this.commandList;
    }

    @Override
    public boolean accepts(RetaskingMsg.COMMANDTYPE command) {
        return this.commandList.contains((Object)command);
    }

    @Override
    public Map<SIXTH.RIGHT, Integer> getAccessRights() {
        HashMap<SIXTH.RIGHT, Integer> rights = new HashMap<SIXTH.RIGHT, Integer>();
        rights.put(SIXTH.RIGHT.ACCESS_DATA, 0);
        rights.put(SIXTH.RIGHT.ACCESS_DESCRIPTIONS, 1);
        rights.put(SIXTH.RIGHT.ACCESS_SENSORS, 2);
        rights.put(SIXTH.RIGHT.ACCESS_ADAPTOR, 3);
        return rights;
    }

    public void ping() {
    }

    public List<ISensorNode> getNodes(IQuery query) {
        Vector<ISensorNode> nodes = new Vector<ISensorNode>();
        for (ISensorNode iSensorNode : nodes) {
            if (!query.match(iSensorNode)) continue;
            nodes.add(iSensorNode);
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ISensorNode> getNodes(String nodeType) {
        Vector<ISensorNode> nodes = new Vector<ISensorNode>();
        Map<Integer, ISensorNode> map = this.sensors;
        synchronized (map) {
            for (ISensorNode iSensorNode : this.sensors.values()) {
                log.severe("the sensor type" + iSensorNode.getSensorType());
                if (!iSensorNode.getSensorType().equals(nodeType)) continue;
                nodes.add(iSensorNode);
            }
        }
        return nodes;
    }

    protected String completeSpec(String nodes) {
        return "<adaptorDescription name='" + this.getType() + "'>" + nodes + "</adaptorDescription>";
    }

    protected String getOutput(String type) {
        return "<output type='" + type + "'/>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(IRetensionPolicy retentionPolicy) {
        List<ISensorData> list = this.sensorData;
        synchronized (list) {
            this.sensorData = retentionPolicy.filter(this.sensorData);
        }
    }

    @Override
    public synchronized List<ISensorData> getSensorData() {
        return this.sensorData;
    }

    @Override
    public ISensorNode getNode(int id) {
        return this.sensors.get(id);
    }

    @Override
    public void setTimeoutThreshold(long time) {
        SIXTH.TIMEOUT_THRESHOLD = time;
        this.timeout = time;
        for (ISensorNode sensor : this.sensors.values()) {
            sensor.setTimeoutThreshold(this.timeout);
        }
    }

    @Override
    public void attachNode(ISIXTHNode node) {
        this.node = node;
    }

    @Override
    public ISIXTHNode getNode() {
        return this.node;
    }
}

