/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.core;

import ie.ucd.sixth.core.Frequency;
import ie.ucd.sixth.core.adaptor.AdaptorInformation;
import ie.ucd.sixth.core.query.IQuery;
import java.io.Serializable;

public class RetaskingMsg
implements Serializable {
    private static final long serialVersionUID = -4200344139477751763L;
    public static final byte ALL_SENSORS = 0;
    private Object object;
    private String sensor;
    private int nodeID;
    private COMMANDTYPE command;
    private AdaptorInformation adaptor;

    private RetaskingMsg(int nodeID, String modality, Object val, COMMANDTYPE command) {
        this.sensor = modality;
        this.nodeID = nodeID;
        this.object = val;
        this.command = command;
    }

    private RetaskingMsg(Object val, COMMANDTYPE command) {
        this.object = val;
        this.command = command;
    }

    public void setObject(Object val) {
        this.object = val;
    }

    public void setSensor(String sensor) {
        this.sensor = sensor;
    }

    public void setNodeID(int nodeID) {
        this.nodeID = nodeID;
    }

    public void setCommandType(COMMANDTYPE command) {
        this.command = command;
    }

    public static RetaskingMsg retask(Object instruction) {
        return new RetaskingMsg(instruction, COMMANDTYPE.RETASK);
    }

    public static RetaskingMsg retask(IQuery query) {
        return new RetaskingMsg(query, COMMANDTYPE.QUERY);
    }

    public static RetaskingMsg setSamplingFrequency(int nodeID, String sensor, Frequency freq) {
        return new RetaskingMsg(nodeID, sensor, freq, COMMANDTYPE.SETFREQ);
    }

    public static RetaskingMsg setSamplingFrequency(String sensor, Frequency freq) {
        return new RetaskingMsg(0, sensor, freq, COMMANDTYPE.SETFREQ);
    }

    public static RetaskingMsg requestReading(int nodeID, String sensor) {
        return new RetaskingMsg(nodeID, sensor, null, COMMANDTYPE.REQUESTVALUE);
    }

    public static RetaskingMsg requestSamplingRate(int nodeID, String sensor) {
        return new RetaskingMsg(nodeID, sensor, null, COMMANDTYPE.REQUESTFREQ);
    }

    public static RetaskingMsg retask(int nodeID, String sensor, Object instruction) {
        return new RetaskingMsg(nodeID, sensor, instruction, COMMANDTYPE.RETASK);
    }

    public static RetaskingMsg stopSampling(int nodeID, String sensor) {
        return new RetaskingMsg(nodeID, sensor, 0, COMMANDTYPE.SETFREQ);
    }

    public static RetaskingMsg retask(int nodeID, Object instruction) {
        return new RetaskingMsg(nodeID, null, instruction, COMMANDTYPE.RETASK);
    }

    public String getSensor() {
        return this.sensor;
    }

    public Object getObject() {
        return this.object;
    }

    public int getNodeID() {
        return this.nodeID;
    }

    public COMMANDTYPE getCommandType() {
        return this.command;
    }

    public String toString() {
        return "Retasking Type: " + (Object)((Object)this.command) + " Node: " + this.nodeID + " Sensor: " + this.sensor + " Adaptor: " + this.adaptor;
    }

    public void setAdaptor(AdaptorInformation adaptor) {
        this.adaptor = adaptor;
    }

    public AdaptorInformation getAdaptor() {
        return this.adaptor;
    }

    public static enum COMMANDTYPE {
        SETFREQ,
        REQUESTVALUE,
        REQUESTFREQ,
        RETASK,
        QUERY;

    }
}

