/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.adaptor.shoothillriver;

import ie.ucd.sixth.core.cyber.utils.parsers.XmlToMapConverter;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ShoothillRiverService {
    public static void main(String[] args) {
        ShoothillRiverService test = new ShoothillRiverService();
        Map<Integer, Map<String, String>> dataMap = test.getIndividualDataMaps();
        for (Integer i : dataMap.keySet()) {
            System.out.println("i=" + i + " latitude:" + dataMap.get(i).get("a.latitude") + ", longitude: " + dataMap.get(i).get("a.longitude"));
        }
        System.out.println(dataMap.size());
    }

    public Map<Integer, Map<String, String>> getIndividualDataMaps() {
        HashMap<Integer, Map<String, String>> dataList = new HashMap<Integer, Map<String, String>>();
        Map<String, String> dataMap = this.getRiverLevels();
        int i = 0;
        for (String string : dataMap.keySet()) {
            HashMap<String, String> map;
            String value = dataMap.get(string);
            if (string.contains("." + i + ".")) {
                string = string.replace("." + i + ".", ".");
                if (!dataList.containsKey(i)) {
                    map = new HashMap<String, String>();
                    map.put(string, value);
                    dataList.put(i, map);
                    continue;
                }
                ((Map)dataList.get(i)).put(string, value);
                continue;
            }
            if (!string.contains("." + ++i + ".")) continue;
            string = string.replace("." + i + ".", ".");
            if (!dataList.containsKey(i)) {
                map = new HashMap();
                map.put(string, value);
                dataList.put(i, map);
                continue;
            }
            ((Map)dataList.get(i)).put(string, value);
        }
        System.out.println("RIVERS RETURNING THIS MUCH DATA... " + dataList.size());
        return dataList;
    }

    public Map<String, String> getRiverLevels() {
        String RIVER_API_KEY = "8000f20a-9409-4eb2-88e2-79b81aac6078";
        String authURL = "http://riverlevelsapi.shoothill.com/ApiAccount/APILogin";
        String riverURL = "http://riverlevelsapi.shoothill.com/TimeSeries/GetTimeSeriesStations?dataTypes=3";
        String postData = "{'PublicApiKey': '" + RIVER_API_KEY + "','ApiVersion': '2'}";
        String sessionHeaderId = this.post(authURL, postData);
        String data = this.getData(riverURL, sessionHeaderId);
        Map dataMap = new XmlToMapConverter().parse(data);
        return dataMap;
    }

    public String post(String request, String postData) {
        String sessionHeaderId = "";
        try {
            Pattern regex;
            Matcher regexMatcher;
            URL url = new URL(request);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Content-Length", String.valueOf(postData.length()));
            conn.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(postData);
            wr.flush();
            int HttpResult = conn.getResponseCode();
            if (HttpResult == 200 && (regexMatcher = (regex = Pattern.compile("\"SessionHeaderId\":\"(.*?)\"")).matcher(this.getContent(conn))).find()) {
                sessionHeaderId = regexMatcher.group(1);
            }
            return sessionHeaderId;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getData(String request, String sessionHeaderId) {
        String retval = "";
        try {
            URL url = new URL(request);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("SessionHeaderId", sessionHeaderId);
            conn.setDoOutput(true);
            retval = this.getContent(conn);
        }
        catch (Exception exception) {}
        return retval;
    }

    public String getContent(HttpURLConnection conn) {
        StringBuffer sb = new StringBuffer();
        try {
            BufferedInputStream is = new BufferedInputStream(conn.getInputStream());
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String inputLine = "";
            while ((inputLine = br.readLine()) != null) {
                sb.append(inputLine);
            }
        }
        catch (Exception exception) {}
        String data = sb.toString();
        return data;
    }
}

