/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.adaptor.shoothillriver;

import ie.ucd.sixth.adaptor.shoothillriver.ShoothillRiverService;
import ie.ucd.sixth.core.cyber.adaptor.sensor.AbstractAdaptorStream;
import ie.ucd.sixth.core.cyber.adaptor.sensor.AbstractCyberAdaptor;
import ie.ucd.sixth.core.cyber.adaptor.sensor.AggregateProperty;
import ie.ucd.sixth.core.cyber.adaptor.sensor.CyberSensorData;
import ie.ucd.sixth.core.cyber.sensor.CyberSensor;
import ie.ucd.sixth.core.cyber.sensor.EntityCyberSensor;
import ie.ucd.sixth.core.cyber.sensor.LocationCyberSensor;
import ie.ucd.sixth.core.cyber.utils.geocode.WorldCoordinates;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ShoothillRiverAdaptorStream
extends AbstractAdaptorStream
implements Runnable {
    private ShoothillRiverService resourceManager = new ShoothillRiverService();
    private int frequencySeconds = 30;
    private boolean threadStopped;

    public ShoothillRiverAdaptorStream(AbstractCyberAdaptor adaptor) {
        super(adaptor);
    }

    public void stream() {
        logger.info("in stream");
        if (this.active) {
            this.shutdown();
            logger.info("the stream was active so we shut it down");
        }
        if (!this.aggregateProperties.isEmpty()) {
            logger.info("aggregate properties map is not empty");
            this.threadStopped = false;
            logger.info("about to start thread");
            this.active = true;
            this.setFrequency();
            new Thread(this).start();
        } else {
            logger.info("AGGREGATE PROPERTIES MAP IS EMPTY");
        }
    }

    public synchronized void setFrequency() {
        this.frequencySeconds = 5;
    }

    public void shutdown() {
        if (this.active) {
            this.active = false;
        }
    }

    public void start() {
        if (this.active) {
            this.shutdown();
        }
        this.stream();
    }

    protected void queueStart(CyberSensor sensor) {
        this.start();
    }

    @Override
    public void run() {
        logger.info("starting weather stream...");
        WorldCoordinates world = new WorldCoordinates();
        world.getMap();
        this.active = true;
        if (this.aggregateProperties.isEmpty()) {
            this.active = false;
            System.out.println("no properties...");
        }
        logger.info("checking aggregate properties... ");
        for (String propertyname : this.aggregateProperties.keySet()) {
            logger.info("property name: " + propertyname + " values: " + ((AggregateProperty)this.aggregateProperties.get(propertyname)).getValues());
        }
        while (this.getFrequency() > 0) {
            Set values;
            this.threadStopped = false;
            if (this.aggregateProperties.containsKey("keyword")) {
                final AggregateProperty keywords = (AggregateProperty)this.aggregateProperties.get("keyword");
                values = keywords.getValues();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Map<Integer, Map<String, String>> floodData = ShoothillRiverAdaptorStream.this.resourceManager.getIndividualDataMaps();
                        for (Integer i : floodData.keySet()) {
                            Map<String, String> dataMap = floodData.get(i);
                            if (!dataMap.containsKey(ShoothillRiverAdaptorStream.this.adaptor.getDataModel().getEntityPath())) continue;
                            String entity = dataMap.get(ShoothillRiverAdaptorStream.this.adaptor.getDataModel().getEntityPath());
                            for (String string : values) {
                                string = string.toLowerCase();
                                entity = entity.toLowerCase();
                                logger.info("checking values.... ");
                                if (!entity.contains(string) && !string.equalsIgnoreCase("all")) continue;
                                List sensors = keywords.getSensorsForValue(string);
                                for (Integer integer : sensors) {
                                    EntityCyberSensor sensor = (EntityCyberSensor)ShoothillRiverAdaptorStream.this.sensorMap.get(integer);
                                    if (sensor == null) continue;
                                    CyberSensorData data = new CyberSensorData(sensor.getNetwork(), sensor.getID(), String.valueOf(sensor.getSensorType()) + ":" + sensor.getSensedModality(), dataMap, "periodic", System.currentTimeMillis(), ShoothillRiverAdaptorStream.this.adaptor.getDataModel());
                                    ShoothillRiverAdaptorStream.this.pushDataToSensor((CyberSensor)sensor, data);
                                }
                            }
                        }
                    }
                }).start();
            }
            if (this.aggregateProperties.containsKey("locationname")) {
                logger.info("have location values.....");
                AggregateProperty locationNames = (AggregateProperty)this.aggregateProperties.get("locationname");
                values = locationNames.getValues();
                Map<Integer, Map<String, String>> floodData = this.resourceManager.getIndividualDataMaps();
                for (Integer i : floodData.keySet()) {
                    logger.info("values: " + values);
                    for (String string : values) {
                        Map<String, String> weatherMap = floodData.get(i);
                        if (!weatherMap.containsKey(this.adaptor.getDataModel().getLocationNamePath()) && !string.equalsIgnoreCase("all")) continue;
                        String locName = weatherMap.get(this.adaptor.getDataModel().getLocationNamePath());
                        logger.info("checking location name: " + locName);
                        if ((locName == null || !locName.toLowerCase().contains(string.toLowerCase())) && !string.equalsIgnoreCase("all")) continue;
                        List sensors = locationNames.getSensorsForValue(string);
                        logger.info("have sensors or are they null? " + (sensors == null));
                        for (Integer integer : sensors) {
                            logger.info("sensor: " + integer + ": " + (this.sensorMap.get(integer) == null));
                            LocationCyberSensor sensor = (LocationCyberSensor)this.sensorMap.get(integer);
                            if (sensor == null) continue;
                            CyberSensorData data = new CyberSensorData(sensor.getNetwork(), sensor.getID(), String.valueOf(sensor.getSensorType()) + ":" + sensor.getSensedModality(), weatherMap, "periodic", System.currentTimeMillis(), this.adaptor.getDataModel());
                            logger.info("created data object");
                            this.pushDataToSensor((CyberSensor)sensor, data);
                            logger.info("data has been sent to sensor");
                        }
                    }
                }
            }
            try {
                Thread.sleep(this.getFrequency() * 1000);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("frequency has changed...... " + this.getFrequency());
        this.threadStopped = true;
        this.active = false;
    }

    public synchronized int getFrequency() {
        return this.frequencySeconds;
    }
}

