/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.examples.friendship;

import twitter4j.Friendship;
import twitter4j.ResponseList;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;

public final class LookupFriendships {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: java twitter4j.examples.user.LookupFriendships [screen name[,screen name..]]");
            System.exit(-1);
        }
        try {
            Twitter twitter = new TwitterFactory().getInstance();
            ResponseList friendships = twitter.lookupFriendships(args[0].split(","));
            for (Friendship friendship : friendships) {
                System.out.println("@" + friendship.getScreenName() + " following: " + friendship.isFollowing() + " followed_by: " + friendship.isFollowedBy());
            }
            System.out.println("Successfully looked up friendships [" + args[0] + "].");
            System.exit(0);
        }
        catch (TwitterException te) {
            te.printStackTrace();
            System.out.println("Failed to lookup friendships: " + te.getMessage());
            System.exit(-1);
        }
    }
}

