/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.service.adaptor.klout;

import ie.ucd.sixth.core.cyber.utils.UrlRequester;
import ie.ucd.sixth.core.cyber.utils.parsers.XmlToMapConverter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ResourceManager {
    private int callsPerRequest = 2;
    private int maxCallsPerSecond = 10;
    private long nanoTimeBetweenCalls = 200000000L;
    private long lastCallTime = 0L;
    private Map<String, String> kloutidentities;
    private final String API_KEY = "key=xuau7ge9sncjhygknesupcby";
    private UrlRequester urlRequester = new UrlRequester();
    private XmlToMapConverter converter = new XmlToMapConverter();

    public ResourceManager() {
        this.kloutidentities = new HashMap<String, String>();
    }

    public Map<String, String> getData(String type, String modalityValue) {
        long difference = System.nanoTime() - this.getLastCallTime();
        if (difference < this.nanoTimeBetweenCalls) {
            System.out.println("waiting");
            try {
                long wait = TimeUnit.MILLISECONDS.convert(this.nanoTimeBetweenCalls - difference, TimeUnit.NANOSECONDS);
                Thread.sleep(wait);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (type.equalsIgnoreCase("Twitter_KloutScore")) {
            return this.getKloutScore(modalityValue);
        }
        if (type.equalsIgnoreCase("Twitter_KloutInfluence")) {
            return this.getKloutInfluenceData(modalityValue);
        }
        if (type.equalsIgnoreCase("Twitter_KloutTopics")) {
            return this.getKloutTopicData(modalityValue);
        }
        this.setLastCallTime(System.nanoTime());
        return null;
    }

    private synchronized long getLastCallTime() {
        return this.lastCallTime;
    }

    private synchronized void setLastCallTime(long lastCallTime) {
        this.lastCallTime = lastCallTime;
    }

    private Map<String, String> getKloutScore(String screenname) {
        String url = "http://api.klout.com/v2/user.json/" + this.getKloutIdentity(screenname) + "/score?" + "key=xuau7ge9sncjhygknesupcby";
        return this.converter.parse(this.urlRequester.makeRequest(url));
    }

    private Map<String, String> getKloutTopicData(String screenname) {
        String url = "http://api.klout.com/v2/user.json/" + this.getKloutIdentity(screenname) + "/topics?" + "key=xuau7ge9sncjhygknesupcby";
        return this.converter.parse(this.urlRequester.makeRequest(url));
    }

    private Map<String, String> getKloutInfluenceData(String screenname) {
        String url = "http://api.klout.com/v2/user.json/" + this.getKloutIdentity(screenname) + "/influence?" + "key=xuau7ge9sncjhygknesupcby";
        return this.converter.parse(this.urlRequester.makeRequest(url));
    }

    private String getKloutIdentity(String twitterUserName_or_id) {
        if (this.kloutidentities.containsKey(twitterUserName_or_id)) {
            return this.kloutidentities.get(twitterUserName_or_id);
        }
        String url = "http://api.klout.com/v2/identity.json/twitter?screenName=" + twitterUserName_or_id + "&" + "key=xuau7ge9sncjhygknesupcby";
        Map map = this.converter.parse(this.urlRequester.makeRequest(url));
        this.kloutidentities.put(twitterUserName_or_id, (String)map.get("id"));
        return (String)map.get("id");
    }

    public static void main(String[] args) {
        ResourceManager test = new ResourceManager();
        Map<String, String> dataMap = test.getKloutScore("olgamurdoch");
        for (Map.Entry<String, String> entry : dataMap.entrySet()) {
            System.out.println(String.valueOf(entry.getKey()) + ", " + entry.getValue());
        }
    }
}

