/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.service.adaptor.klout;

import ie.ucd.sixth.core.cyber.adaptor.pipe.AbstractPipeAdaptor;
import ie.ucd.sixth.core.cyber.adaptor.pipe.AbstractPipeFactory;
import ie.ucd.sixth.core.cyber.pipe.AbstractPipeService;
import ie.ucd.sixth.core.service.IPipeService;
import ie.ucd.sixth.service.adaptor.klout.KloutPipeAdaptor;
import ie.ucd.sixth.service.pipe.klout.fusers.TwitterScreenName_KloutInfluence_Fuser;
import ie.ucd.sixth.service.pipe.klout.fusers.TwitterScreenName_KloutScore_Fuser;
import ie.ucd.sixth.service.pipe.klout.fusers.TwitterScreenName_KloutTopics_Fuser;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KloutPipeFactory
extends AbstractPipeFactory {
    private static final Logger log = Logger.getLogger(KloutPipeFactory.class.getName());
    private KloutPipeAdaptor adaptor;

    static {
        log.setLevel(Level.SEVERE);
    }

    public KloutPipeFactory(AbstractPipeAdaptor adaptor) {
        super(adaptor);
        this.adaptor = (KloutPipeAdaptor)adaptor;
    }

    public IPipeService createPipe(String serviceName) {
        int id = this.generateId();
        this.adaptor.sendSensorCreationConfirmation(id, "klout", "fuser", serviceName);
        return this.createPipe(this.adaptor, serviceName, id);
    }

    public IPipeService createPipe(AbstractPipeAdaptor ad, String serviceName, int id) {
        log.info("in kloutpipefactory.createPipe()");
        if (serviceName.equalsIgnoreCase("Twitter_KloutInfluence")) {
            TwitterScreenName_KloutInfluence_Fuser pipe = new TwitterScreenName_KloutInfluence_Fuser(ad, id);
            this.addPipe(id, (AbstractPipeService)pipe);
            ad.addPipeToMap(id, (AbstractPipeService)pipe);
            return pipe;
        }
        if (serviceName.equalsIgnoreCase("Twitter_KloutScore")) {
            TwitterScreenName_KloutScore_Fuser pipe = new TwitterScreenName_KloutScore_Fuser(ad, id);
            this.addPipe(id, (AbstractPipeService)pipe);
            ad.addPipeToMap(id, (AbstractPipeService)pipe);
            return pipe;
        }
        if (serviceName.equalsIgnoreCase("Twitter_KloutTopics")) {
            TwitterScreenName_KloutTopics_Fuser pipe = new TwitterScreenName_KloutTopics_Fuser(ad, id);
            this.addPipe(id, (AbstractPipeService)pipe);
            ad.addPipeToMap(id, (AbstractPipeService)pipe);
            return pipe;
        }
        return null;
    }
}

