/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.service.adaptor.klout;

import ie.ucd.sixth.core.cyber.adaptor.pipe.AbstractPipeAdaptor;
import ie.ucd.sixth.core.cyber.adaptor.sensor.ParseSensorProperties;
import ie.ucd.sixth.core.cyber.pipe.AbstractFuserPipe;
import ie.ucd.sixth.core.discovery.ISIXTHNode;
import ie.ucd.sixth.core.service.IPipeService;
import ie.ucd.sixth.service.adaptor.klout.KloutPipeFactory;
import ie.ucd.sixth.service.adaptor.klout.ResourceManager;
import ie.ucd.sixth.service.pipe.klout.fusers.TwitterScreenName_KloutInfluence_Fuser;
import ie.ucd.sixth.service.pipe.klout.fusers.TwitterScreenName_KloutScore_Fuser;
import ie.ucd.sixth.service.pipe.klout.fusers.TwitterScreenName_KloutTopics_Fuser;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;

public class KloutPipeAdaptor
extends AbstractPipeAdaptor {
    private static final Logger log = Logger.getLogger(KloutPipeAdaptor.class.getName());
    private static final int maxCallsPerSecond = 10;
    private static int totalCallsThisSecond;
    private static long timeSinceLastCall;
    private ResourceManager resourceManager;
    private BundleContext bundleContext;

    static {
        log.setLevel(Level.ALL);
        totalCallsThisSecond = 0;
        timeSinceLastCall = 0L;
    }

    public KloutPipeAdaptor(BundleContext bundleContext, String type) {
        super(bundleContext, type);
        this.bundleContext = bundleContext;
        this.factory = new KloutPipeFactory(this);
        this.resourceManager = new ResourceManager();
        this.registerFactory(this.factory);
    }

    protected void configurePipe(int pipeId, ParseSensorProperties parser) {
        log.info("CONFIGURING KLOUT PIPE: pipeId=" + pipeId);
        Map propertiesMap = parser.getPropertiesMap();
        if (propertiesMap == null || propertiesMap.isEmpty()) {
            log.info("no properties set");
            return;
        }
        log.info("properties set...");
        for (Map.Entry entry : propertiesMap.entrySet()) {
            log.info(String.valueOf((String)entry.getKey()) + ", " + (String)entry.getValue());
        }
        if (pipeId == 0) {
            log.info("pipeId could not be resolved");
            return;
        }
        log.info("printing the ids from the pipemap in KloutPipeAdaptor: " + this.pipeMap.size());
        Set idSet = this.pipeMap.keySet();
        for (Integer string : idSet) {
            log.info("id: " + string);
        }
        log.info("finsihed printing ids");
        if (this.pipeMap.containsKey(pipeId)) {
            AbstractFuserPipe pipe;
            log.info("configuring id:" + pipeId);
            String serviceName = ((IPipeService)this.pipeMap.get(pipeId)).getName();
            log.info("servicename: " + serviceName);
            if (serviceName.equalsIgnoreCase("Twitter_KloutInfluence")) {
                pipe = (TwitterScreenName_KloutInfluence_Fuser)((Object)this.pipeMap.get(pipeId));
                for (Map.Entry property : propertiesMap.entrySet()) {
                    log.info("TwitterScreenName_KloutInfluence_Fuser: setting property:" + (String)property.getKey() + ", " + (String)property.getValue());
                    pipe.setProperty((String)property.getKey(), (String)property.getValue());
                }
            } else if (serviceName.equalsIgnoreCase("Twitter_KloutScore")) {
                pipe = (TwitterScreenName_KloutScore_Fuser)((Object)this.pipeMap.get(pipeId));
                for (Map.Entry property : propertiesMap.entrySet()) {
                    log.info("TwitterScreenName_KloutScore_Fuser: setting property:" + (String)property.getKey() + ", " + (String)property.getValue());
                    pipe.setProperty((String)property.getKey(), (String)property.getValue());
                }
            } else if (serviceName.equalsIgnoreCase("Twitter_KloutTopics")) {
                pipe = (TwitterScreenName_KloutTopics_Fuser)((Object)this.pipeMap.get(pipeId));
                for (Map.Entry property : propertiesMap.entrySet()) {
                    log.info("TwitterScreenName_KloutTopics_Fuser: setting property:" + (String)property.getKey() + ", " + (String)property.getValue());
                    pipe.setProperty((String)property.getKey(), (String)property.getValue());
                }
            }
        } else {
            log.info("could not configure pipe");
        }
    }

    public String getSpecification() {
        String influencedByDesc = "<pipe type='fuser.Twitter_KloutInfluence' id='0000000'><property name='modality' type='String' /></pipe>";
        String kloutScoreDesc = "<pipe type='fuser.Twitter_KloutScore' id='0000000'><property name='modality' type='String' /></pipe>";
        String kloutTopicsDesc = "<pipe type='fuser.Twitter_KloutTopics' id='0000000'><property name='modality' type='String' /></pipe>";
        String spec = "<adaptorDescription name='klout'>" + influencedByDesc + kloutScoreDesc + kloutTopicsDesc + "<output type='text'/></adaptorDescription>";
        return spec;
    }

    public void attachNode(ISIXTHNode node) {
    }

    public ISIXTHNode getNode() {
        return null;
    }

    public Map<String, String> getResource(String pipename, String modalityValue) {
        return this.resourceManager.getData(pipename, modalityValue);
    }

    protected void createPipe(String serviceName) {
        log.info("CREATING KLOUT PIPE");
        this.factory.createPipe(serviceName);
    }
}

