/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.cybersensor.klout.utils;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class KloutParser {
    private static final Logger log = Logger.getLogger(KloutParser.class.getName());

    static {
        log.setLevel(Level.SEVERE);
    }

    public Map<String, String> parseUserData(String userdata) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        String klouttag = "klout.";
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(userdata));
            Document doc = db.parse(is);
            String userTag = String.valueOf(klouttag) + "user.";
            NodeList userNodes = doc.getElementsByTagName("user");
            int i = 0;
            while (i < userNodes.getLength()) {
                Node userNode = userNodes.item(i);
                NodeList dataNodes = userNode.getChildNodes();
                int j = 0;
                while (j < dataNodes.getLength()) {
                    Node dataNode = dataNodes.item(j);
                    String name = dataNode.getNodeName();
                    String text = dataNode.getTextContent();
                    if (name.equalsIgnoreCase("twitter_id")) {
                        dataMap.put(String.valueOf(userTag) + name, text);
                    } else if (name.equalsIgnoreCase("twitter_screen_name")) {
                        dataMap.put(String.valueOf(userTag) + name, text);
                    } else if (name.equalsIgnoreCase("score")) {
                        String scoreTag = String.valueOf(klouttag) + userTag + "score.";
                        NodeList scoreNodes = dataNode.getChildNodes();
                        int k = 0;
                        while (k < scoreNodes.getLength()) {
                            Node scoreNode = scoreNodes.item(k);
                            String nodeName = scoreNode.getNodeName();
                            String nodeContent = scoreNode.getTextContent();
                            String nodeTag = String.valueOf(scoreTag) + nodeName;
                            dataMap.put(nodeTag, nodeContent);
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return dataMap;
    }

    public Map<String, String> parseTopicData(String topicdata) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        String klouttag = "klout.";
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(topicdata));
            Document doc = db.parse(is);
            String userTag = String.valueOf(klouttag) + "user.";
            NodeList userNodes = doc.getElementsByTagName("user");
            int i = 0;
            while (i < userNodes.getLength()) {
                Node userNode = userNodes.item(i);
                NodeList dataNodes = userNode.getChildNodes();
                int j = 0;
                while (j < dataNodes.getLength()) {
                    Node dataNode = dataNodes.item(j);
                    String name = dataNode.getNodeName();
                    String text = dataNode.getTextContent();
                    if (name.equalsIgnoreCase("twitter_screen_name")) {
                        dataMap.put(String.valueOf(userTag) + name, text);
                    } else if (name.equalsIgnoreCase("topics")) {
                        String topicsTag = String.valueOf(klouttag) + userTag + "topics";
                        NodeList TopicNodes = dataNode.getChildNodes();
                        String topiclist = "";
                        int k = 0;
                        while (k < TopicNodes.getLength()) {
                            Node topicNode = TopicNodes.item(k);
                            String nodeName = topicNode.getNodeName();
                            String nodeContent = topicNode.getTextContent();
                            if (nodeName.equalsIgnoreCase("topic")) {
                                topiclist = String.valueOf(topiclist) + nodeContent + ";";
                            }
                            ++k;
                        }
                        log.info("adding topics: " + topiclist);
                        dataMap.put(topicsTag, topiclist);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return dataMap;
    }

    public Map<String, String> parseInfluencedByData(String influencedByData) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        String klouttag = "klout.";
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(influencedByData));
            Document doc = db.parse(is);
            String userTag = String.valueOf(klouttag) + "user.";
            NodeList userNodes = doc.getElementsByTagName("user");
            int i = 0;
            while (i < userNodes.getLength()) {
                Node userNode = userNodes.item(i);
                NodeList dataNodes = userNode.getChildNodes();
                int j = 0;
                while (j < dataNodes.getLength()) {
                    Node dataNode = dataNodes.item(j);
                    String name = dataNode.getNodeName();
                    String text = dataNode.getTextContent();
                    if (name.equalsIgnoreCase("twitter_screen_name")) {
                        dataMap.put(String.valueOf(userTag) + name, text);
                    } else if (name.equalsIgnoreCase("influencers")) {
                        String influencersTag = String.valueOf(klouttag) + userTag + "influencers";
                        NodeList influencerNodes = dataNode.getChildNodes();
                        String influencerList = "";
                        int k = 0;
                        while (k < influencerNodes.getLength()) {
                            Node inflencerNode = influencerNodes.item(k);
                            String nodeName = inflencerNode.getNodeName();
                            String nodeContent = inflencerNode.getTextContent();
                            if (nodeName.equalsIgnoreCase("twitter_screen_name")) {
                                influencerList = String.valueOf(influencerList) + nodeContent + ";";
                            }
                            ++k;
                        }
                        dataMap.put(influencersTag, influencerList);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return dataMap;
    }

    public Map<String, String> parseInfluencerOfData(String influencerOfData) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        String klouttag = "klout.";
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(influencerOfData));
            Document doc = db.parse(is);
            String userTag = String.valueOf(klouttag) + "user.";
            NodeList userNodes = doc.getElementsByTagName("user");
            int i = 0;
            while (i < userNodes.getLength()) {
                Node userNode = userNodes.item(i);
                NodeList dataNodes = userNode.getChildNodes();
                int j = 0;
                while (j < dataNodes.getLength()) {
                    Node dataNode = dataNodes.item(j);
                    String name = dataNode.getNodeName();
                    String text = dataNode.getTextContent();
                    if (name.equalsIgnoreCase("twitter_screen_name")) {
                        dataMap.put(String.valueOf(userTag) + name, text);
                    } else if (name.equalsIgnoreCase("influencees")) {
                        String influenceesTag = String.valueOf(klouttag) + userTag + "influencees";
                        NodeList influenceeNodes = dataNode.getChildNodes();
                        String influenceeList = "";
                        int k = 0;
                        while (k < influenceeNodes.getLength()) {
                            Node inflencerNode = influenceeNodes.item(k);
                            String nodeName = inflencerNode.getNodeName();
                            String nodeContent = inflencerNode.getTextContent();
                            if (nodeName.equalsIgnoreCase("twitter_screen_name")) {
                                influenceeList = String.valueOf(influenceeList) + nodeContent + ";";
                            }
                            ++k;
                        }
                        dataMap.put(influenceesTag, influenceeList);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return dataMap;
    }
}

