/*
 * Decompiled with CFR 0.152.
 */
package widgets;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class UserList {
    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame f = new JFrame("Users");
                f.setDefaultCloseOperation(3);
                f.setSize(300, 300);
                JList<User> list = new JList<User>(new Vector<User>(){
                    {
                        this.add(new User("A", false));
                        this.add(new User("B", true));
                        this.add(new User("C", true));
                        this.add(new User("D", false));
                    }
                });
                list.setCellRenderer(new DefaultListCellRenderer(){

                    @Override
                    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                        if (value instanceof User) {
                            User nextUser = (User)value;
                            this.setText(nextUser.name);
                            if (nextUser.loggedIn) {
                                this.setBackground(Color.GREEN);
                            } else {
                                this.setBackground(Color.RED);
                            }
                            if (isSelected) {
                                this.setBackground(this.getBackground().darker());
                            }
                        } else {
                            this.setText("whodat?");
                        }
                        return c;
                    }
                });
                f.add((Component)new JScrollPane(list), "Center");
                f.setVisible(true);
            }
        });
    }

    static class User {
        String name = "NN";
        boolean loggedIn = false;

        public User(String name, boolean loggedIn) {
            this.name = name;
            this.loggedIn = loggedIn;
        }
    }
}

