/*
 * Decompiled with CFR 0.152.
 */
package widgets;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class GridLayoutdemo
extends JFrame {
    static final String[] gapList = new String[]{"0", "10", "15", "20"};
    static final int maxGap = 20;
    JComboBox horGapComboBox;
    JComboBox verGapComboBox;
    JButton applyButton = new JButton("Apply gaps");
    GridLayout experimentLayout = new GridLayout(0, 2);

    public GridLayoutdemo(String name) {
        super(name);
        this.setResizable(false);
    }

    public void initGaps() {
        this.horGapComboBox = new JComboBox<String>(gapList);
        this.verGapComboBox = new JComboBox<String>(gapList);
    }

    public void addComponentsToPane(Container pane) {
        this.initGaps();
        final JPanel compsToExperiment = new JPanel();
        compsToExperiment.setLayout(this.experimentLayout);
        JPanel controls = new JPanel();
        controls.setLayout(new GridLayout(2, 3));
        JButton b = new JButton("Just fake button");
        Dimension buttonSize = b.getPreferredSize();
        compsToExperiment.setPreferredSize(new Dimension((int)(buttonSize.getWidth() * 2.5) + 20, (int)(buttonSize.getHeight() * 3.5) + 40));
        compsToExperiment.add(new JButton("Button 1"));
        compsToExperiment.add(new JButton("Button 2"));
        compsToExperiment.add(new JButton("Button 3"));
        compsToExperiment.add(new JButton("Long-Named Button 4"));
        compsToExperiment.add(new JButton("5"));
        controls.add(new Label("Horizontal gap:"));
        controls.add(new Label("Vertical gap:"));
        controls.add(new Label(" "));
        controls.add(this.horGapComboBox);
        controls.add(this.verGapComboBox);
        controls.add(this.applyButton);
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String horGap = (String)GridLayoutdemo.this.horGapComboBox.getSelectedItem();
                String verGap = (String)GridLayoutdemo.this.verGapComboBox.getSelectedItem();
                GridLayoutdemo.this.experimentLayout.setHgap(Integer.parseInt(horGap));
                GridLayoutdemo.this.experimentLayout.setVgap(Integer.parseInt(verGap));
                GridLayoutdemo.this.experimentLayout.layoutContainer(compsToExperiment);
            }
        });
        pane.add((Component)compsToExperiment, "North");
        pane.add((Component)new JSeparator(), "Center");
        pane.add((Component)controls, "South");
    }

    private static void createAndShowGUI() {
        GridLayoutdemo frame = new GridLayoutdemo("GridLayoutDemo");
        frame.setDefaultCloseOperation(3);
        frame.addComponentsToPane(frame.getContentPane());
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (UnsupportedLookAndFeelException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        UIManager.put("swing.boldMetal", Boolean.FALSE);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GridLayoutdemo.createAndShowGUI();
            }
        });
    }
}

