/*
 * Decompiled with CFR 0.152.
 */
package dashboard;

import ie.ucd.sixth.core.service.IServiceFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.MapMarkerDot;
import org.openstreetmap.gui.jmapviewer.MapMarkerImage;
import org.openstreetmap.gui.jmapviewer.MapMarkerRectangle;
import org.openstreetmap.gui.jmapviewer.MapMarkerTriangle;
import org.openstreetmap.gui.jmapviewer.OsmFileCacheTileLoader;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.events.JMVCommandEvent;
import org.openstreetmap.gui.jmapviewer.interfaces.JMapViewerEventListener;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.BingAerialTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.MapQuestOpenAerialTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.MapQuestOsmTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;

public class MapViewFrame
extends JInternalFrame
implements JMapViewerEventListener {
    private static final long serialVersionUID = 1L;
    static int openFrameCount = 0;
    static final int xOffset = 30;
    static final int yOffset = 30;
    public static final String TYPE = "map";
    public static String RECTANGLE_MARKER_TYPE = "rectangle";
    public static String TRIANGLE_MARKER_TYPE = "triangle";
    public static String CIRCLE_MARKER_TYPE = "circle";
    public static String PLOT_TYPE_PROPERTY = "plottype";
    public static String LATITUDE_MODALITY_PROPERTY = "latitude";
    public static String LONGITUDE_MODALITY_PROPERTY = "longitude";
    private Map<String, Color> modalityColours = new HashMap<String, Color>();
    private static JMapViewer map = null;
    private JLabel zoomLabel = null;
    private JLabel zoomValue = null;
    private JLabel mperpLabelName = null;
    private JLabel mperpLabelValue = null;
    private int ID;
    private IServiceFactory widgetFactory;
    private String longitudePath;
    private String latitudePath;

    public MapViewFrame() {
        super("Map #" + ++openFrameCount, true, true, true, true);
        JComboBox<TileLoader> tileLoaderSelector;
        this.setSize(400, 400);
        map = new JMapViewer();
        map.addJMVListener((JMapViewerEventListener)this);
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        JPanel helpPanel = new JPanel();
        this.mperpLabelName = new JLabel("Meters/Pixels: ");
        this.mperpLabelValue = new JLabel(String.format("%s", map.getMeterPerPixel()));
        this.zoomLabel = new JLabel("Zoom: ");
        this.zoomValue = new JLabel(String.format("%s", map.getZoom()));
        this.add((Component)panel, "North");
        this.add((Component)helpPanel, "South");
        JLabel helpLabel = new JLabel("Use right mouse button to move,\n left double click or mouse wheel to zoom.");
        helpPanel.add(helpLabel);
        JButton button = new JButton("setDisplayToFitMapMarkers");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                map.setDisplayToFitMapMarkers();
            }
        });
        JComboBox<TileSource> tileSourceSelector = new JComboBox<TileSource>(new TileSource[]{new OsmTileSource.Mapnik(), new OsmTileSource.CycleMap(), new BingAerialTileSource(), new MapQuestOsmTileSource(), new MapQuestOpenAerialTileSource()});
        tileSourceSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                map.setTileSource((TileSource)e.getItem());
            }
        });
        try {
            tileLoaderSelector = new JComboBox<TileLoader>(new TileLoader[]{new OsmFileCacheTileLoader((TileLoaderListener)map), new OsmTileLoader((TileLoaderListener)map)});
        }
        catch (IOException iOException) {
            tileLoaderSelector = new JComboBox<TileLoader>(new TileLoader[]{new OsmTileLoader((TileLoaderListener)map)});
        }
        tileLoaderSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                map.setTileLoader((TileLoader)e.getItem());
            }
        });
        map.setTileLoader((TileLoader)tileLoaderSelector.getSelectedItem());
        panel.add(tileSourceSelector);
        panel.add(tileLoaderSelector);
        final JCheckBox showMapMarker = new JCheckBox("Map markers visible");
        showMapMarker.setSelected(map.getMapMarkersVisible());
        showMapMarker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                map.setMapMarkerVisible(showMapMarker.isSelected());
            }
        });
        panel.add(showMapMarker);
        final JCheckBox showTileGrid = new JCheckBox("Tile grid visible");
        showTileGrid.setSelected(map.isTileGridVisible());
        showTileGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                map.setTileGridVisible(showTileGrid.isSelected());
            }
        });
        panel.add(showTileGrid);
        final JCheckBox showZoomControls = new JCheckBox("Show zoom controls");
        showZoomControls.setSelected(map.getZoomContolsVisible());
        showZoomControls.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                map.setZoomContolsVisible(showZoomControls.isSelected());
            }
        });
        panel.add(showZoomControls);
        panel.add(button);
        panel.add(this.zoomLabel);
        panel.add(this.zoomValue);
        panel.add(this.mperpLabelName);
        panel.add(this.mperpLabelValue);
        this.add((Component)map, "Center");
        this.setLocation(30 * openFrameCount, 30 * openFrameCount);
    }

    public static void main(String[] args) {
        new MapViewFrame().setVisible(true);
    }

    private void updateZoomParameters() {
        if (this.mperpLabelValue != null) {
            this.mperpLabelValue.setText(String.format("%s", map.getMeterPerPixel()));
        }
        if (this.zoomValue != null) {
            this.zoomValue.setText(String.format("%s", map.getZoom()));
        }
    }

    public void processCommand(JMVCommandEvent command) {
        if (command.getCommand().equals((Object)JMVCommandEvent.COMMAND.ZOOM) || command.getCommand().equals((Object)JMVCommandEvent.COMMAND.MOVE)) {
            this.updateZoomParameters();
        }
    }

    public static synchronized void addExternalMapMarker(Color colour, Double lat, Double lon) {
        map.addMapMarker((MapMarker)new MapMarkerDot(colour, lat.doubleValue(), lon.doubleValue()));
        System.out.println("plotted circle " + colour.toString() + " .. ...........................................................");
    }

    public static synchronized void addExternalRectMapMarker(Color colour, Double lat, Double lon) {
        map.addMapMarker((MapMarker)new MapMarkerRectangle(colour, lat.doubleValue(), lon.doubleValue()));
    }

    public static synchronized void addExternalTriangleMapMarker(Color colour, Double lat, Double lon) {
        map.addMapMarker((MapMarker)new MapMarkerTriangle(colour, lat.doubleValue(), lon.doubleValue()));
    }

    public synchronized void addExternalImageMapMarker(Image image, Double lat, Double lon) {
        map.addMapMarker((MapMarker)new MapMarkerImage(image, lat.doubleValue(), lon.doubleValue()));
    }

    public synchronized void addData(String markerShape, Color markerColour, Double latitude, Double longitude, String plotItem, String plotValue) {
    }

    public synchronized void addData(Image markerImage, Double latitude, Double longitude, String plotItem, String plotValue) {
    }
}

