/*
 * Decompiled with CFR 0.152.
 */
package dashboard;

import dashboard.Swingwork;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class DynamicSensorDataListModel
extends JPanel {
    private static final long serialVersionUID = 1L;
    JList list;
    DefaultListModel model;
    int counter = 15;
    private int selected = -1;
    GridLayout experimentLayout = new GridLayout(0, 2);
    JComboBox networkTypeBox;
    JComboBox sensorTypeBox;
    static JTable dataTable;
    JTextField invariantBox;
    private String[] networkTypes = new String[]{"twitter", "worldweather"};
    private String[] sensorTypes = new String[]{"entity", "location", "user"};
    final DefaultComboBoxModel modalitymodel = new DefaultComboBoxModel();
    JComboBox modalityListBox = new JComboBox(this.modalitymodel);
    private TableModel tableModel;

    private synchronized void setModel(Map<String, String> values) {
        this.modalitymodel.removeAllElements();
        for (String m : values.keySet()) {
            this.modalitymodel.addElement(m);
        }
    }

    private synchronized void initBoxes() {
        this.networkTypeBox = new JComboBox<String>(this.networkTypes);
        this.sensorTypeBox = new JComboBox<String>(this.sensorTypes);
        this.invariantBox = new JTextField();
        this.tableModel = new DefaultTableModel();
        dataTable = new JTable(this.tableModel);
    }

    private synchronized void setSelected(int index) {
        this.selected = index;
    }

    private synchronized int getSelected() {
        return this.selected;
    }

    public DynamicSensorDataListModel() {
        this.setLayout(new BorderLayout());
        this.initBoxes();
        JButton applyButton = new JButton("Start Sensor");
        JButton tagButton = new JButton("Tag Data");
        JPanel userTagControls = new JPanel();
        userTagControls.setLayout(new GridLayout(2, 2));
        userTagControls.add(new Label("modality to tag:"));
        userTagControls.add(new Label(" "));
        userTagControls.add(this.modalityListBox);
        userTagControls.add(tagButton);
        JPanel configControls = new JPanel();
        configControls.setLayout(new GridLayout(2, 4));
        configControls.add(new Label("network type:"));
        configControls.add(new Label("sensor type:"));
        configControls.add(new Label("invariant value:"));
        configControls.add(new Label(" "));
        configControls.add(this.networkTypeBox);
        configControls.add(this.sensorTypeBox);
        configControls.add(this.invariantBox);
        configControls.add(applyButton);
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        JScrollPane pane = new JScrollPane(dataTable);
        JButton addButton = new JButton("Tag Data");
        final JTextField tagField = new JTextField("Enter your data tag here                                      ");
        tagField.setEditable(true);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (!event.getValueIsAdjusting()) {
                    JList source = (JList)event.getSource();
                    DynamicSensorDataListModel.this.setSelected(source.getSelectedIndex());
                }
            }
        });
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DynamicSensorDataListModel.this.getSelected() != -1) {
                    String selectedData = (String)DynamicSensorDataListModel.this.model.getElementAt(DynamicSensorDataListModel.this.getSelected());
                    DynamicSensorDataListModel.this.addData("<originalData>" + selectedData + "</originalData><userTag>" + tagField.getText() + "</userTag>");
                }
            }
        });
        this.add((Component)configControls, "North");
        this.add((Component)pane, "Center");
        this.add((Component)userTagControls, "South");
    }

    public synchronized void addData(String dataString) {
        this.model.add(0, dataString);
    }

    private static void execTask() {
        Swingwork mainWorker = new Swingwork(dataTable);
        mainWorker.execute();
    }

    public static void main(String[] s) {
        JFrame frame = new JFrame("List Model Example");
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(new DynamicSensorDataListModel());
        frame.setSize(260, 200);
        frame.setVisible(true);
    }
}

