/*
 * Decompiled with CFR 0.152.
 */
package dashboard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class DesktopScrollPane
extends JScrollPane {
    private JDesktopPane desktopPane;
    private InternalFrameComponentListener componentListener = new InternalFrameComponentListener();

    public DesktopScrollPane(JDesktopPane desktopPane) {
        this.desktopPane = desktopPane;
        desktopPane.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                DesktopScrollPane.this.onComponentAdded(e);
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                DesktopScrollPane.this.onComponentRemoted(e);
            }
        });
        this.setViewportView(desktopPane);
        this.setVerticalScrollBarPolicy(20);
        this.setHorizontalScrollBarPolicy(30);
    }

    private void onComponentRemoted(ContainerEvent event) {
        Component removedComponent = event.getChild();
        if (removedComponent instanceof JInternalFrame) {
            removedComponent.removeComponentListener(this.componentListener);
        }
    }

    private void onComponentAdded(ContainerEvent event) {
        Component addedComponent = event.getChild();
        if (addedComponent instanceof JInternalFrame) {
            addedComponent.addComponentListener(this.componentListener);
            this.resizeDesktop();
        }
    }

    public JInternalFrame[] getAllFrames() {
        return this.desktopPane.getAllFrames();
    }

    public void setDesktopSize(Dimension dim) {
        this.desktopPane.setPreferredSize(dim);
        this.desktopPane.revalidate();
    }

    public void resizeDesktop() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Rectangle viewPort = DesktopScrollPane.this.getViewport().getViewRect();
                int maxX = viewPort.width + viewPort.x;
                int maxY = viewPort.height + viewPort.y;
                int minX = viewPort.x;
                int minY = viewPort.y;
                JInternalFrame frame = null;
                JInternalFrame[] frames = DesktopScrollPane.this.getAllFrames();
                int i = 0;
                while (i < frames.length) {
                    frame = frames[i];
                    if (frame.getX() < minX) {
                        minX = frame.getX();
                    }
                    if (frame.getX() + frame.getWidth() > maxX) {
                        maxX = frame.getX() + frame.getWidth();
                    }
                    if (frame.getY() < minY) {
                        minY = frame.getY();
                    }
                    if (frame.getY() + frame.getHeight() > maxY) {
                        maxY = frame.getY() + frame.getHeight();
                    }
                    ++i;
                }
                if (minX < 0) {
                    minX = 0;
                }
                if (minY < 0) {
                    minY = 0;
                }
                DesktopScrollPane.this.setVisible(false);
                if (minX != 0 || minY != 0) {
                    i = 0;
                    while (i < frames.length) {
                        frame = frames[i];
                        frame.setLocation(frame.getX() - minX, frame.getY() - minY);
                        ++i;
                    }
                    JViewport view = DesktopScrollPane.this.getViewport();
                    view.setViewSize(new Dimension(maxX - minX, maxY - minY));
                    view.setViewPosition(new Point(viewPort.x - minX, viewPort.y - minY));
                    DesktopScrollPane.this.setViewport(view);
                }
                DesktopScrollPane.this.setDesktopSize(new Dimension(maxX - minX, maxY - minY));
                DesktopScrollPane.this.setVisible(true);
            }
        });
    }

    private class InternalFrameComponentListener
    implements ComponentListener {
        private InternalFrameComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            DesktopScrollPane.this.resizeDesktop();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            DesktopScrollPane.this.resizeDesktop();
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }
    }
}

