/*
 * Decompiled with CFR 0.152.
 */
package dashboard;

import buildingblocks.DiscoveryReceiver;
import dashboard.DesktopScrollPane;
import dashboard.DynamicListPanel;
import dashboard.MapViewFrame;
import dashboard.ScrollDesktop;
import ie.ucd.sixth.core.adaptor.AdaptorInformation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import widgets.SIXTHConfigurationWidget;

public class Dashboard
extends JFrame
implements ActionListener {
    JDesktopPane desktop;
    JScrollPane scrollPane;
    private DynamicListPanel list;
    private static MapViewFrame map;
    private DiscoveryReceiver discovery;
    private Map<String, AdaptorInformation> pipes;
    private Map<String, AdaptorInformation> sensors;
    private Map<String, SIXTHConfigurationWidget> configurationWidgets;

    public Dashboard(String dashboardTitle, DiscoveryReceiver discovery) {
        super(dashboardTitle);
        this.discovery = discovery;
        this.configurationWidgets = new HashMap<String, SIXTHConfigurationWidget>();
        int inset = 50;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(inset, inset, screenSize.width - inset * 2, screenSize.height - inset * 2);
        this.list = new DynamicListPanel();
        this.list.setBounds(0, 0, 200, 1200);
        this.list.setVisible(true);
        this.desktop = new ScrollDesktop();
        this.desktop = new JDesktopPane();
        DesktopScrollPane scrollpane = new DesktopScrollPane(this.desktop);
        this.desktop.add(this.list);
        map = new MapViewFrame();
        this.addWidget(map);
        this.setContentPane(scrollpane);
        this.setJMenuBar(this.createMenuBar());
        this.desktop.setDragMode(1);
    }

    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Document");
        menu.setMnemonic(68);
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("New");
        menuItem.setMnemonic(78);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(78, 8));
        menuItem.setActionCommand("new");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new JMenuItem("Quit");
        menuItem.setMnemonic(81);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(81, 8));
        menuItem.setActionCommand("quit");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        return menuBar;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("new".equals(e.getActionCommand())) {
            SIXTHConfigurationWidget widget = new SIXTHConfigurationWidget("");
            widget.setVisible(true);
            this.desktop.add(widget);
            try {
                widget.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
        } else {
            this.quit();
        }
    }

    public void addWidget(JInternalFrame widget) {
        widget.setVisible(true);
        this.desktop.add((Component)widget, new Integer(20));
        try {
            widget.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    protected void quit() {
        System.exit(0);
    }

    public static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        Dashboard frame = new Dashboard("my awesome dashboard", null);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        Dashboard demo = new Dashboard("", null);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Dashboard.createAndShowGUI();
            }
        });
        int i = 0;
        while (i < 1000) {
            try {
                demo.addExternalMapMarker(Color.RED, 51.601142, 0.218069);
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public void addData(String string) {
        this.list.addData(string);
    }

    public void addExternalMapMarker(Color markerColour, Double latitude, Double longitude) {
        System.out.println("about to add map marker: " + latitude + "," + longitude);
        MapViewFrame.addExternalMapMarker(markerColour, latitude, longitude);
    }
}

