/*
 * Decompiled with CFR 0.152.
 */
package buildingblocks;

import buildingblocks.AbstractApplication;
import buildingblocks.Pipe;
import ie.ucd.sixth.core.sensor.data.SensorData;
import ie.ucd.sixth.core.utils.Property;
import ie.ucd.sixth.core.utils.SensorSpecification;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Sensor {
    private static final Logger logger = Logger.getLogger(Sensor.class.getName());
    private String TYPE_STRING = "string";
    private String TYPE_INTEGER = "integer";
    private String TYPE_BOOLEAN = "boolean";
    protected long frequency = 60L;
    protected int sensorId = 0;
    protected String configurationXML = "";
    protected String sensorType;
    protected String adaptorName;
    protected SensorData data;
    protected List<Property> properties;
    protected Map<String, String> propertyTypes;
    protected Map<String, String> taskedProperties;
    protected boolean sensorTasked = false;
    protected boolean sensorReady = false;
    protected int networkID = 0;
    protected String invariant = "";

    static {
        logger.setLevel(Level.OFF);
    }

    protected Sensor(String adaptorName, String sensorType) {
        this.sensorType = sensorType;
        this.adaptorName = adaptorName;
    }

    protected String getInvariant() {
        return this.invariant;
    }

    protected void printProperties() {
        if (this.properties != null && !this.properties.isEmpty()) {
            for (Property property : this.properties) {
                System.out.println("Property information for: " + this.adaptorName + "." + this.sensorType);
                System.out.println("sensor id if any: " + this.sensorId);
                System.out.println("Property: NAME=" + property.getName() + " - TYPE" + property.getType() + " - CONTENT: " + property.getContent());
            }
        }
    }

    public void task(String propertyValue) {
        if (this.sensorType.equalsIgnoreCase("entity")) {
            this.task("keyword", propertyValue);
        } else if (this.sensorType.equalsIgnoreCase("location")) {
            if (propertyValue.contains(",")) {
                String[] check = propertyValue.split(",");
                if (check.length == 2) {
                    try {
                        Double.parseDouble(check[0]);
                        Double.parseDouble(check[1]);
                        this.task("latlong", propertyValue);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.task("locationname", propertyValue);
                    }
                } else if (check.length == 4) {
                    try {
                        Double.parseDouble(check[0]);
                        Double.parseDouble(check[1]);
                        Double.parseDouble(check[2]);
                        Double.parseDouble(check[3]);
                        this.task("boundingbox", propertyValue);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.task("locationname", propertyValue);
                    }
                }
            } else {
                this.task("locationname", propertyValue);
            }
        } else if (this.sensorType.equalsIgnoreCase("user")) {
            this.task("userid", propertyValue);
        }
    }

    protected void task(String propertyName, String propertyValue) {
        if (propertyName.equalsIgnoreCase("keyword") || propertyName.equalsIgnoreCase("locationname") || propertyName.equalsIgnoreCase("userid")) {
            this.invariant = propertyValue;
        }
        if (this.taskedProperties == null) {
            this.taskedProperties = new HashMap<String, String>();
        }
        for (Property property : this.properties) {
            if (!property.getName().equalsIgnoreCase(propertyName)) continue;
            String type = property.getType();
            if (type.equalsIgnoreCase(this.TYPE_STRING)) {
                this.taskedProperties.put(propertyName, propertyValue);
            } else if (type.equalsIgnoreCase(this.TYPE_BOOLEAN)) {
                if (Arrays.asList("on", "off").contains(propertyValue)) {
                    this.taskedProperties.put(propertyName, propertyValue);
                }
            } else if (type.equalsIgnoreCase(this.TYPE_INTEGER) && Sensor.isInteger(propertyValue)) {
                this.taskedProperties.put(propertyName, propertyValue);
            }
            this.sensorTasked = true;
            break;
        }
    }

    public void start() {
        if (this.sensorTasked && this.sensorReady) {
            logger.info("sending retask from sensor with adaptor name: " + this.adaptorName + "and current configuration: " + this.getCurrentConfiguration());
            boolean success = AbstractApplication.sendRetask(this.getCurrentConfiguration(), this.adaptorName);
            if (!success) {
                System.err.println("Sensor could not be started. This is most likely due to its adaptor type being missing... ");
                AbstractApplication.printAvailableInfrastructure();
                System.exit(0);
            }
        } else {
            if (!this.sensorTasked) {
                System.out.println("sensor has not been tasked so we print an error and quit....................................................................");
                System.err.println("You must task the sensor before you start it. Do this by using the sensor.task(propertyName, propertyValue) method \n here are your options: \n");
                for (Property property : this.properties) {
                    System.err.println("Property Name: " + property.getName() + " required Type: " + property.getType());
                }
                System.exit(0);
            }
            if (!this.sensorReady) {
                System.out.println("olga needs to fix this - the sensor doesnt have its id yet");
                System.exit(0);
            }
        }
    }

    protected void setID(int sensorID) {
        this.sensorId = sensorID;
        this.sensorReady = true;
    }

    protected int getID() {
        return this.sensorId;
    }

    public synchronized String getCurrentConfiguration() {
        if (this.adaptorName.equalsIgnoreCase("twitter")) {
            this.frequency = 1L;
        }
        String xmlRetaskString = "<configureSensor><sensor type='" + this.adaptorName + "." + this.sensorType + "' id='" + this.sensorId + "'>" + "<property name='frequency'>" + this.frequency + "</property>";
        if (this.taskedProperties != null) {
            Set<String> set = this.taskedProperties.keySet();
            for (String string : set) {
                xmlRetaskString = String.valueOf(xmlRetaskString) + "<property name='" + string + "'>" + this.taskedProperties.get(string) + "</property>";
            }
        }
        xmlRetaskString = String.valueOf(xmlRetaskString) + "<property name='state'>on</property></sensor></configureSensor>";
        return xmlRetaskString;
    }

    protected void setConfiguration(String configurationXML) {
        this.configurationXML = configurationXML;
    }

    protected void setSpecification(SensorSpecification sensorSpecification) {
        logger.info("setting sensor spec: " + sensorSpecification);
        this.properties = sensorSpecification.getProperties();
        logger.info("have properties: " + this.properties.size());
        for (Property property : this.properties) {
            logger.info("property name: " + property.getName());
        }
        this.propertyTypes = sensorSpecification.getMap();
        for (String type : this.propertyTypes.keySet()) {
            logger.info("key: " + type + " value: " + this.propertyTypes.get(type));
        }
    }

    protected static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyPipe(Pipe pipe) {
        Pipe pipe2 = pipe;
        synchronized (pipe2) {
            if (!pipe.isReady()) {
                try {
                    pipe.wait(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        this.taskedProperties.put("pipe", String.valueOf(pipe.getID()));
    }

    public void applyPipeLine(List<Pipe> pipeline) {
        String value = "";
        for (Pipe pipe : pipeline) {
            value = String.valueOf(value) + pipe.getID() + ";";
        }
        this.taskedProperties.put("pipe", value);
    }

    public String getSensorType() {
        return this.sensorType;
    }

    public String getNetworkType() {
        return this.adaptorName;
    }
}

