/*
 * Decompiled with CFR 0.152.
 */
package buildingblocks;

import buildingblocks.AbstractApplication;
import ie.ucd.sixth.core.utils.Property;
import ie.ucd.sixth.core.utils.SensorSpecification;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Pipe {
    private String TYPE_STRING = "string";
    private String TYPE_INTEGER = "integer";
    private String TYPE_BOOLEAN = "boolean";
    private int pipeId = 0;
    private String xmlCreateString = "";
    private String configurationXML = "";
    private String pipeType;
    private String adaptorName;
    private List<Property> properties;
    private Map<String, String> propertyTypes;
    private Map<String, String> taskedProperties;
    private boolean pipeTasked = false;
    private boolean pipeReady = false;

    protected Pipe(String adaptorName, String pipeType) {
        this.pipeType = pipeType;
        this.adaptorName = adaptorName;
    }

    protected void printProperties() {
        for (Property property : this.properties) {
            System.out.println("Property information for: " + this.adaptorName + "." + this.pipeType);
            System.out.println("pipe id if any: " + this.pipeId);
            System.out.println("Property: NAME=" + property.getName() + " - TYPE" + property.getType() + " - CONTENT: " + property.getContent());
        }
    }

    public void task(String propertyName, String propertyValue) {
        if (this.taskedProperties == null) {
            this.taskedProperties = new HashMap<String, String>();
        }
        for (Property property : this.properties) {
            if (!property.getName().equalsIgnoreCase(propertyName)) continue;
            String type = property.getType();
            if (type.equalsIgnoreCase(this.TYPE_STRING)) {
                this.taskedProperties.put(propertyName, propertyValue);
            } else if (type.equalsIgnoreCase(this.TYPE_BOOLEAN)) {
                if (Arrays.asList("on", "off").contains(propertyValue)) {
                    this.taskedProperties.put(propertyName, propertyValue);
                }
            } else if (type.equalsIgnoreCase(this.TYPE_INTEGER) && Pipe.isInteger(propertyValue)) {
                this.taskedProperties.put(propertyName, propertyValue);
            }
            Set<String> set = this.taskedProperties.keySet();
            for (String string : set) {
                System.out.println("set property key: " + string + " set properties value: " + this.taskedProperties.get(string));
            }
            this.pipeTasked = true;
            AbstractApplication.sendRetask(this.getCurrentConfiguration(), this.adaptorName);
            break;
        }
    }

    protected void setID(int sensorID) {
        this.pipeId = sensorID;
        this.pipeReady = true;
    }

    protected int getID() {
        return this.pipeId;
    }

    protected String getType() {
        return this.pipeType;
    }

    protected String getAdaptorName() {
        return this.adaptorName;
    }

    public synchronized String getCurrentConfiguration() {
        String xmlRetaskString = "<configurePipe><service type='" + this.adaptorName + "' id='" + this.pipeId + "'>";
        if (this.taskedProperties != null) {
            Set<String> set = this.taskedProperties.keySet();
            for (String string : set) {
                xmlRetaskString = String.valueOf(xmlRetaskString) + "<property name='" + string + "'>" + this.taskedProperties.get(string) + "</property>";
            }
        }
        xmlRetaskString = String.valueOf(xmlRetaskString) + "</service></configurePipe>";
        return xmlRetaskString;
    }

    protected void setConfiguration(String configurationXML) {
        this.configurationXML = configurationXML;
    }

    protected void setSpecification(SensorSpecification sensorSpecification) {
        this.properties = sensorSpecification.getProperties();
        this.propertyTypes = sensorSpecification.getMap();
    }

    protected static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    protected boolean isReady() {
        return this.pipeReady;
    }
}

