/*
 * Decompiled with CFR 0.152.
 */
package buildingblocks;

import buildingblocks.AbstractApplication;
import buildingblocks.Sensor;
import ie.ucd.sixth.core.utils.Property;
import java.util.Set;

public class Network
extends Sensor {
    private boolean generateUsers = false;
    private boolean generateEntities = false;
    private boolean generateLocations = false;
    protected String userrule = "user";
    protected String entityrule = "entity";
    protected String locationrule = "location";

    protected Network(String adaptorName, String sensorType) {
        super(adaptorName, sensorType);
    }

    public void generateUsers() {
        this.task("generateusersensors", "on");
        this.generateUsers = true;
    }

    public void generateEntities() {
        this.task("generateentitysensors", "on");
        this.generateEntities = true;
    }

    public void generateLocations() {
        this.task("generatelocationsensors", "on");
        this.generateLocations = true;
    }

    @Override
    public void start() {
        if (this.sensorTasked && this.sensorReady) {
            boolean success = AbstractApplication.sendRetask(this.getCurrentConfiguration(), this.adaptorName);
            if (!success) {
                System.err.println("Network could not be started. This is most likely due to its adaptor type being missing... ");
                AbstractApplication.printAvailableInfrastructure();
                System.exit(0);
            }
        } else {
            if (!this.sensorTasked) {
                System.out.println("Network has not been tasked so we print an error and quit....................................................................");
                System.err.println("You must task the Network before you start it. Do this by using the network.task(propertyName, propertyValue) method \n here are your options: \n");
                for (Property property : this.properties) {
                    System.err.println("Property Name: " + property.getName() + " required Type: " + property.getType());
                }
                System.exit(0);
            }
            if (!this.sensorReady) {
                System.out.println("olga needs to fix this - the network doesnt have its id yet");
                System.exit(0);
            }
        }
    }

    @Override
    public synchronized String getCurrentConfiguration() {
        String xmlRetaskString = "<configureNetwork><network type='" + this.adaptorName + "." + this.sensorType + "' id='" + this.sensorId + "'>" + "<property name='frequency'>" + this.frequency + "</property>";
        if (this.taskedProperties != null) {
            Set set = this.taskedProperties.keySet();
            for (String string : set) {
                xmlRetaskString = String.valueOf(xmlRetaskString) + "<property name='" + string + "'>" + (String)this.taskedProperties.get(string) + "</property>";
            }
        }
        xmlRetaskString = String.valueOf(xmlRetaskString) + "<property name='state'>on</property></network></configureNetwork>";
        System.out.println("network is returning configuration: " + xmlRetaskString);
        return xmlRetaskString;
    }

    private void createPipeRule(String pipeAdaptorName, String pipeType, String serviceName, String rule) {
        this.taskedProperties.put(String.valueOf(rule) + "pipe", String.valueOf(pipeAdaptorName) + "." + pipeType + "." + serviceName);
    }

    public void applyFuserPipeToUsers(String pipeAdaptorName, String serviceName) {
        this.createPipeRule(pipeAdaptorName, "fuser", serviceName, this.userrule);
    }

    public void applyFuserPipeToEntities(String pipeAdaptorName, String serviceName) {
        this.createPipeRule(pipeAdaptorName, "fuser", serviceName, this.entityrule);
    }

    public void applyFuserPipeToLocations(String pipeAdaptorName, String serviceName) {
        this.createPipeRule(pipeAdaptorName, "fuser", serviceName, this.locationrule);
    }
}

