/*
 * Decompiled with CFR 0.152.
 */
package buildingblocks;

import buildingblocks.AbstractApplication;
import buildingblocks.Network;
import ie.ucd.sixth.core.utils.Property;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Infrastructure
extends Network {
    private static final Logger logger = Logger.getLogger(Infrastructure.class.getName());
    protected String invariant = "";
    private boolean generateUsersFromEntities = false;
    private boolean generateUsersFromLocations = false;
    private boolean generateUsersFromUsers = false;
    private boolean generateEntitiesFromEntities = false;
    private boolean generateEntitiesFromLocations = false;
    private boolean generateEntitiesFromUsers = false;
    private boolean generateLocationsFromEntities = false;
    private boolean generateLocationsFromLocations = false;
    private boolean generateLocationsFromUsers = false;
    private String baseAdaptor = "";
    private String baseType = "";

    static {
        logger.setLevel(Level.ALL);
    }

    protected Infrastructure(String adaptorName, String sensorType) {
        super(adaptorName, sensorType);
    }

    @Override
    public void generateUsers() {
        this.task("generateusersensors", "all");
    }

    public void generateUsers(String adaptorName) {
        this.task("generateusersensors", adaptorName);
    }

    @Override
    public void generateEntities() {
        this.task("generateentitysensors", "all");
    }

    public void generateEntities(String adaptorName) {
        this.task("generateentitysensors", adaptorName);
    }

    @Override
    public void generateLocations() {
        this.task("generatelocationsensors", "all");
    }

    public void generateLocations(String adaptorName) {
        this.task("generatelocationsensors", adaptorName);
    }

    public void generateUsersFromUsers() {
        this.generateUsersRule(this.userrule, "all");
    }

    public void generateUsersFromEntities() {
        this.generateUsersRule(this.entityrule, "all");
    }

    public void generateUsersFromLocations() {
        this.generateUsersRule(this.locationrule, "all");
    }

    public void generateUsersFromUsers(String adaptorname) {
        this.generateUsersRule(this.userrule, adaptorname);
    }

    public void generateUsersFromEntities(String adaptorname) {
        this.generateUsersRule(this.entityrule, adaptorname);
    }

    public void generateUsersFromLocations(String adaptorname) {
        this.generateUsersRule(this.locationrule, adaptorname);
    }

    public void generateEntitiesFromEntities() {
        this.generateEntitiesRule(this.entityrule, "all");
    }

    public void generateEntitiesFromLocations() {
        this.generateEntitiesRule(this.locationrule, "all");
    }

    public void generateEntitiesFromUsers() {
        this.generateEntitiesRule(this.userrule, "all");
    }

    public void generateEntitiesFromEntities(String adaptorname) {
        this.generateEntitiesRule(this.entityrule, adaptorname);
    }

    public void generateEntitiesFromLocations(String adaptorname) {
        this.generateEntitiesRule(this.locationrule, adaptorname);
    }

    public void generateEntitiesFromUsers(String adaptorname) {
        this.generateEntitiesRule(this.userrule, adaptorname);
    }

    public void generateLocationsFromLocations() {
        this.generateLocationsRule(this.locationrule, "all");
    }

    public void generateLocationsFromEntities() {
        this.generateLocationsRule(this.entityrule, "all");
    }

    public void generateLocationsFromUsers() {
        this.generateLocationsRule(this.userrule, "all");
    }

    public void generateLocationsFromLocations(String adaptorname) {
        this.generateLocationsRule(this.locationrule, adaptorname);
    }

    public void generateLocationsFromEntities(String adaptorname) {
        this.generateLocationsRule(this.entityrule, adaptorname);
    }

    public void generateLocationsFromUsers(String adaptorname) {
        this.generateLocationsRule(this.userrule, adaptorname);
    }

    private void generateUsersRule(String rule, String adaptorName) {
        if (rule.equalsIgnoreCase(this.userrule)) {
            this.generateUsersFromUsers = true;
            this.task("generateusersfromusers", adaptorName);
        } else if (rule.equalsIgnoreCase(this.entityrule)) {
            this.generateUsersFromEntities = true;
            this.task("generateusersfromentities", adaptorName);
        } else if (rule.equalsIgnoreCase(this.locationrule)) {
            this.generateUsersFromLocations = true;
            this.task("generateusersfromlocations", adaptorName);
        }
    }

    private void generateEntitiesRule(String rule, String adaptorName) {
        if (rule.equalsIgnoreCase(this.userrule)) {
            this.generateEntitiesFromUsers = true;
            this.task("generateentitiesfromusers", adaptorName);
        } else if (rule.equalsIgnoreCase(this.entityrule)) {
            this.generateEntitiesFromEntities = true;
            this.task("generateentitiesfromentities", adaptorName);
        } else if (rule.equalsIgnoreCase(this.locationrule)) {
            this.generateEntitiesFromLocations = true;
            this.task("generateentitiesfromlocations", adaptorName);
        }
    }

    private void generateLocationsRule(String rule, String adaptorName) {
        if (rule.equalsIgnoreCase(this.userrule)) {
            this.generateLocationsFromUsers = true;
            this.task("generatelocationsfromusers", adaptorName);
        } else if (rule.equalsIgnoreCase(this.entityrule)) {
            this.generateLocationsFromEntities = true;
            this.task("generatelocationsfromentities", adaptorName);
        } else if (rule.equalsIgnoreCase(this.locationrule)) {
            this.generateLocationsFromLocations = true;
            this.task("generatelocationsfromlocations", adaptorName);
        }
    }

    @Override
    public void start() {
        if (this.sensorTasked && this.sensorReady) {
            boolean success = AbstractApplication.sendRetask(this.getCurrentConfiguration(), this.adaptorName);
            if (!success) {
                System.err.println("Network could not be started. This is most likely due to its adaptor type being missing... ");
                AbstractApplication.printAvailableInfrastructure();
                System.exit(0);
            }
        } else {
            if (!this.sensorTasked) {
                System.out.println("Network has not been tasked so we print an error and quit....................................................................");
                System.err.println("You must task the Network before you start it. Do this by using the network.task(propertyName, propertyValue) method \n here are your options: \n");
                for (Property property : this.properties) {
                    System.err.println("Property Name: " + property.getName() + " required Type: " + property.getType());
                }
                System.exit(0);
            }
            if (!this.sensorReady) {
                System.out.println("olga needs to fix this - the network doesnt have its id yet");
                System.exit(0);
            }
        }
    }

    private void createPipeRule(String pipeAdaptorName, String pipeType, String serviceName, String rule) {
        this.taskedProperties.put(String.valueOf(rule) + "pipe", String.valueOf(pipeAdaptorName) + "." + pipeType + "." + serviceName);
    }

    @Override
    public void applyFuserPipeToUsers(String pipeAdaptorName, String serviceName) {
        this.createPipeRule(pipeAdaptorName, "fuser", serviceName, this.userrule);
    }

    @Override
    public void applyFuserPipeToEntities(String pipeAdaptorName, String serviceName) {
        this.createPipeRule(pipeAdaptorName, "fuser", serviceName, this.entityrule);
    }

    @Override
    public void applyFuserPipeToLocations(String pipeAdaptorName, String serviceName) {
        this.createPipeRule(pipeAdaptorName, "fuser", serviceName, this.locationrule);
    }

    @Override
    public synchronized String getCurrentConfiguration() {
        String xmlRetaskString = "<configureInfrastructure><infrastructure type='" + this.adaptorName + "." + this.sensorType + "' id='" + this.sensorId + "'>" + "<property name='frequency'>" + this.frequency + "</property>";
        if (this.taskedProperties != null) {
            Set set = this.taskedProperties.keySet();
            for (String string : set) {
                xmlRetaskString = String.valueOf(xmlRetaskString) + "<property name='" + string + "'>" + (String)this.taskedProperties.get(string) + "</property>";
            }
        }
        xmlRetaskString = String.valueOf(xmlRetaskString) + "<property name='state'>on</property></infrastructure></configureInfrastructure>";
        System.out.println("network is returning configuration: " + xmlRetaskString);
        return xmlRetaskString;
    }
}

