/*
 * Decompiled with CFR 0.152.
 */
package buildingblocks;

import buildingblocks.AbstractApplication;
import ie.ucd.sixth.core.RetaskingMsg;
import ie.ucd.sixth.core.SIXTH;
import ie.ucd.sixth.core.adaptor.AdaptorInformation;
import ie.ucd.sixth.core.adaptor.ISensorAdaptor;
import ie.ucd.sixth.core.discovery.IAdaptorAccess;
import ie.ucd.sixth.core.discovery.IDiscovery;
import ie.ucd.sixth.core.discovery.IRetaskingService;
import ie.ucd.sixth.core.receiver.IAdaptorReceiver;
import ie.ucd.sixth.core.receiver.IEventReceiver;
import ie.ucd.sixth.core.receiver.INodeReceiver;
import ie.ucd.sixth.core.sensor.ISensor;
import ie.ucd.sixth.core.sensor.ISensorNode;
import ie.ucd.sixth.core.sensor.NodeDescription;
import ie.ucd.sixth.core.sensor.NodeProperty;
import ie.ucd.sixth.core.sensor.SensorDescription;
import ie.ucd.sixth.core.service.IPipeAdaptor;
import ie.ucd.sixth.core.service.IServiceFactory;
import ie.ucd.sixth.core.utils.AdaptorSpecification;
import ie.ucd.sixth.core.utils.AdaptorSpecificationParser;
import ie.ucd.sixth.core.utils.SensorSpecification;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class DiscoveryReceiver
implements IEventReceiver,
INodeReceiver,
IAdaptorReceiver {
    IDiscovery discovery = SIXTH.getDiscoveryHandler().getDiscovery("pass");
    IAdaptorAccess adaptorAccess = this.discovery.getAdaptorAccess();
    private ServiceRegistration registration;
    private static Logger logger = Logger.getLogger(DiscoveryReceiver.class.getName());
    private BundleContext context;
    private Bundle bundle;
    private static Map<String, AdaptorInformation> pipeAdaptors;
    private static Map<String, AdaptorInformation> sensorAdaptors;
    private static Map<String, AdaptorInformation> serviceFactories;

    static {
        logger.setLevel(Level.OFF);
    }

    public DiscoveryReceiver(BundleContext context) {
        this.registration = context.registerService(new String[]{IEventReceiver.class.getName(), INodeReceiver.class.getName(), IAdaptorReceiver.class.getName()}, (Object)this, null);
    }

    public void receive(NodeDescription desc, String event) {
        logger.info("EVENT: " + event + " OCCURED SENSOR NODE DESCRIPTION " + desc.getID() + " " + desc.getNetwork() + " " + desc.getSensorType());
        String adaptorType = desc.getAdaptorInformation().getAdaptorType();
        if (adaptorType.equalsIgnoreCase("PIPE_ADAPTOR")) {
            System.exit(0);
        }
    }

    public void receive(ISensorNode sensor, String type) {
        this.receive(sensor.getDescription(), type);
    }

    public void receive(String event) {
        logger.info("EVENT: " + event);
    }

    public String getCredentials() {
        return "pass";
    }

    public void unregister() {
        this.registration.unregister();
    }

    public void receive(AdaptorInformation info, String type) {
        if (info.getAdaptorType().equalsIgnoreCase("PIPE_ADAPTOR")) {
            this.updatePipeAdaptors(this.adaptorAccess.getPipeAdaptors());
        }
        if (info.getAdaptorType().equalsIgnoreCase("SENSOR_ADAPTOR")) {
            this.updateSensorAdaptors(this.adaptorAccess.getSensorAdaptors());
        }
        if (info.getAdaptorType().equalsIgnoreCase("SERVICE_ADAPTOR")) {
            this.updateServiceFactories(this.adaptorAccess.getServiceAdaptors());
        }
    }

    public void receive(SensorDescription sensor, String type) {
        logger.info("EVENT: " + type + " OCCURRED SENSOR " + sensor);
    }

    public void receive(ISensor sensor, String type) {
        logger.info("EVENT: " + type + " OCCURRED SENSOR " + sensor);
        int sensorID = sensor.getNode().getID();
        String adaptorName = sensor.getNode().getNetwork();
        AbstractApplication.setSensorID(adaptorName, type, sensorID);
        NodeProperty networkIDProperty = sensor.getNode().getProperty("networkid");
        NodeProperty infrastructureIDProperty = sensor.getNode().getProperty("infrastructureid");
        if (networkIDProperty != null) {
            String networkID = networkIDProperty.getValue();
            AbstractApplication.setSensorNetworkID(adaptorName, type, sensorID, networkID);
        }
        if (infrastructureIDProperty != null) {
            String infrastructureID = infrastructureIDProperty.getValue();
            AbstractApplication.setSensorInfrastructureID(adaptorName, type, sensorID, infrastructureID);
        }
    }

    public synchronized Map<String, AdaptorInformation> getPipeAdaptors() {
        return pipeAdaptors;
    }

    public synchronized Map<String, AdaptorInformation> getSensorAdaptors() {
        return sensorAdaptors;
    }

    public synchronized Map<String, AdaptorInformation> getServiceFactories() {
        return serviceFactories;
    }

    protected synchronized void updatePipeAdaptors(List<IPipeAdaptor> newAdaptors) {
        if (pipeAdaptors == null) {
            pipeAdaptors = new HashMap<String, AdaptorInformation>();
        }
        for (IPipeAdaptor iPipeAdaptor : newAdaptors) {
            pipeAdaptors.put(iPipeAdaptor.getInfo().getName().toLowerCase(), iPipeAdaptor.getInfo());
        }
    }

    protected synchronized void updateSensorAdaptors(List<ISensorAdaptor> newAdaptors) {
        if (sensorAdaptors == null) {
            sensorAdaptors = new HashMap<String, AdaptorInformation>();
        }
        for (ISensorAdaptor iSensorAdaptor : newAdaptors) {
            sensorAdaptors.put(iSensorAdaptor.getInfo().getName().toLowerCase(), iSensorAdaptor.getInfo());
        }
    }

    protected synchronized void updateServiceFactories(List<IServiceFactory> newFactories) {
        if (serviceFactories == null) {
            serviceFactories = new HashMap<String, AdaptorInformation>();
        }
        for (IServiceFactory iServiceFactory : newFactories) {
            serviceFactories.put(iServiceFactory.getInfo().getName().toLowerCase(), iServiceFactory.getInfo());
        }
    }

    protected synchronized AdaptorInformation getSensorAdaptor(String adaptorName) {
        Set<String> keyset = sensorAdaptors.keySet();
        for (String iSensorAdaptor : keyset) {
            AdaptorInformation info = sensorAdaptors.get(iSensorAdaptor);
            if (!info.getName().equalsIgnoreCase(adaptorName.toLowerCase())) continue;
            return info;
        }
        return null;
    }

    protected synchronized AdaptorInformation getPipeAdaptor(String adaptorName) {
        Set<String> keyset = pipeAdaptors.keySet();
        for (String ipipeadaptor : keyset) {
            AdaptorInformation info = sensorAdaptors.get(ipipeadaptor);
            if (!info.getName().equalsIgnoreCase(adaptorName.toLowerCase())) continue;
            return info;
        }
        return null;
    }

    protected synchronized AdaptorInformation getServiceFactory(String factoryName) {
        Set<String> keyset = serviceFactories.keySet();
        for (String iservicefactory : keyset) {
            AdaptorInformation info = sensorAdaptors.get(iservicefactory);
            if (!info.getName().equalsIgnoreCase(factoryName.toLowerCase())) continue;
            return info;
        }
        return null;
    }

    protected static boolean sendRetask(String xmlString, String adaptorName) {
        logger.info("sending retask with adaptor name: " + adaptorName + ": " + xmlString);
        AdaptorInformation adaptorInfo = null;
        if (sensorAdaptors.containsKey(adaptorName)) {
            adaptorInfo = sensorAdaptors.get(adaptorName);
            logger.info("sensorAdaptors has " + adaptorName + " now have adaptorInfo: " + adaptorInfo.toString());
        } else if (pipeAdaptors.containsKey(adaptorName)) {
            adaptorInfo = pipeAdaptors.get(adaptorName);
        } else if (serviceFactories.containsKey(adaptorName)) {
            adaptorInfo = serviceFactories.get(adaptorName);
        }
        IDiscovery discovery = SIXTH.getDiscoveryHandler().getDiscovery("pass");
        IRetaskingService retaskingService = discovery.getRetaskingService();
        RetaskingMsg msg = RetaskingMsg.retask((Object)xmlString);
        msg.setAdaptor(adaptorInfo);
        boolean success = retaskingService.retask(msg);
        return success;
    }

    protected static void printInfrastructure() {
        if (sensorAdaptors != null) {
            Set<String> sensorSet = sensorAdaptors.keySet();
            System.out.println("Have discovered sensor adaptors ... count = : " + sensorSet.size());
            for (String string : sensorSet) {
                System.out.println("Adaptor Name: " + string);
                System.out.println("Adaptor Specification: " + sensorAdaptors.get(string).getSpec());
            }
        }
        if (pipeAdaptors != null) {
            Set<String> pipeSet = pipeAdaptors.keySet();
            System.out.println("Have discovered pipe adaptors ... count = : " + pipeSet.size());
            for (String string : pipeSet) {
                System.out.println("Adaptor Name: " + string);
                System.out.println("Adaptor Specification: " + pipeAdaptors.get(string).getSpec());
            }
        }
    }

    protected static SensorSpecification createSensor(String xmlString, String adaptorName, String sensorType) {
        logger.info("adaptor name: " + adaptorName);
        if (sensorAdaptors != null) {
            logger.info("sensor adaptors is not null... lets check whats in there... ");
            for (String adaptorname : sensorAdaptors.keySet()) {
                System.out.println("adaptor name: " + adaptorname + " adaptor name from information: " + sensorAdaptors.get(adaptorname).getName());
            }
            if (sensorAdaptors.containsKey(adaptorName)) {
                AdaptorInformation adaptorInfo = sensorAdaptors.get(adaptorName);
                String specString = adaptorInfo.getSpec();
                AdaptorSpecification spec = AdaptorSpecificationParser.parse((String)specString);
                List sensorSpecList = spec.getList();
                for (SensorSpecification sensorSpecification : sensorSpecList) {
                    if (!sensorSpecification.getName().equalsIgnoreCase(sensorType)) continue;
                    DiscoveryReceiver.sendRetask(xmlString, adaptorInfo.getName());
                    return sensorSpecification;
                }
            }
        }
        return null;
    }

    protected static SensorSpecification createPipe(String xmlCreateString, String adaptorName, String pipeType, String serviceType) {
        if (pipeAdaptors.containsKey(adaptorName)) {
            AdaptorInformation adaptorInfo = pipeAdaptors.get(adaptorName);
            String specString = adaptorInfo.getSpec();
            AdaptorSpecification spec = AdaptorSpecificationParser.parse((String)specString);
            List sensorSpecList = spec.getList();
            for (SensorSpecification sensorSpecification : sensorSpecList) {
                sensorSpecification.getName();
                String cfr_ignored_0 = String.valueOf(pipeType) + "." + serviceType;
                if (!sensorSpecification.getName().equalsIgnoreCase(String.valueOf(pipeType) + "." + serviceType)) continue;
                DiscoveryReceiver.sendRetask(xmlCreateString, adaptorInfo.getName());
                return sensorSpecification;
            }
        }
        return null;
    }
}

