/*
 * Decompiled with CFR 0.152.
 */
package buildingblocks;

import buildingblocks.DiscoveryReceiver;
import buildingblocks.Infrastructure;
import buildingblocks.Network;
import buildingblocks.Pipe;
import buildingblocks.Sensor;
import dashboard.Dashboard;
import ie.ucd.sixth.core.Frequency;
import ie.ucd.sixth.core.application.IApplication;
import ie.ucd.sixth.core.receiver.IDataReceiver;
import ie.ucd.sixth.core.sensor.NodeDescription;
import ie.ucd.sixth.core.sensor.data.ISensorData;
import ie.ucd.sixth.core.utils.Property;
import ie.ucd.sixth.core.utils.SensorSpecification;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public abstract class AbstractApplication
implements IApplication,
IDataReceiver {
    private static final Logger logger = Logger.getLogger(AbstractApplication.class.getName());
    private ServiceRegistration registration;
    private BundleContext context;
    private Map<String, Color> modalityColourMap;
    private static Dashboard demo;
    private boolean dataExplorer = false;
    private static Map<String, Queue<Sensor>> sensorQueueMap;
    private static Map<String, Queue<Pipe>> pipeQueueMap;
    private static Map<String, Queue<Network>> networkQueueMap;
    private static Map<Integer, Sensor> sensorMap;
    private static Map<Integer, Pipe> pipeMap;
    private static Map<Integer, Network> networkMap;
    private static Map<Integer, List<Integer>> networkSensorsMap;
    private static Map<Integer, List<Integer>> infrastructureSensorsMap;

    static {
        logger.setLevel(Level.OFF);
        sensorQueueMap = new HashMap<String, Queue<Sensor>>();
        pipeQueueMap = new HashMap<String, Queue<Pipe>>();
        networkQueueMap = new HashMap<String, Queue<Network>>();
        sensorMap = new HashMap<Integer, Sensor>();
        pipeMap = new HashMap<Integer, Pipe>();
        networkMap = new HashMap<Integer, Network>();
        networkSensorsMap = new HashMap<Integer, List<Integer>>();
        infrastructureSensorsMap = new HashMap<Integer, List<Integer>>();
    }

    protected void launchEvaluationInterface() {
    }

    protected void updateEvaluationInterface() {
    }

    protected Pipe createEntityPipe(String string, String string2, String string3) {
        return null;
    }

    protected Pipe createUserAggregatorPipe(String string, String string2) {
        return null;
    }

    protected Pipe createEntityAggregatorPipe(String string, String string2) {
        return null;
    }

    protected void updateLocationViews(ISensorData data) {
    }

    protected void updateSummaryViews(ISensorData data) {
    }

    public AbstractApplication(BundleContext context) {
        this.registration = context.registerService(new String[]{IDataReceiver.class.getName()}, (Object)this, null);
        this.context = context;
        this.modalityColourMap = new HashMap<String, Color>();
        this.setup();
    }

    protected abstract void setup();

    public abstract void respondToData(Sensor var1, ISensorData var2);

    public static Infrastructure createEntityFocusedInfrastructure(String baseAdaptorName, String invariant) {
        Infrastructure infrastructure = AbstractApplication.createInfrastructure(baseAdaptorName, "entity");
        infrastructure.task("invariant", invariant);
        return infrastructure;
    }

    public static Infrastructure createLocationFocusedInfrastructure(String baseAdaptorName, String invariant) {
        Infrastructure infrastructure = AbstractApplication.createInfrastructure(baseAdaptorName, "location");
        infrastructure.task("invariant", invariant);
        return infrastructure;
    }

    public static Infrastructure createUserFocusedInfrastructure(String baseAdaptorName, String invariant) {
        Infrastructure infrastructure = AbstractApplication.createInfrastructure(baseAdaptorName, "user");
        infrastructure.task("invariant", invariant);
        return infrastructure;
    }

    private static Infrastructure createInfrastructure(String adaptorName, String baseSensor) {
        Infrastructure infrastructure = new Infrastructure(adaptorName, baseSensor);
        AbstractApplication.addSensorToQueue(adaptorName, infrastructure);
        String xmlCreateString = "<createInfrastructure><networkType>" + adaptorName + "</networkType><SensorType>" + baseSensor + "</SensorType></createInfrastructure>";
        SensorSpecification sensorSpec = DiscoveryReceiver.createSensor(xmlCreateString, adaptorName, baseSensor);
        Property property1 = new Property("generateentitysensors", "String", "");
        Property property2 = new Property("generatelocationsensors", "String", "");
        Property property3 = new Property("generateusersensors", "String", "");
        Property property4 = new Property("invariant", "String", "");
        Property property5 = new Property("state", "boolean", "");
        Property property6 = new Property("generateentitiesfromentities", "String", "");
        Property property7 = new Property("generateentitiesfromlocations", "String", "");
        Property property8 = new Property("generateentitiesfromusers", "String", "");
        Property property9 = new Property("generatelocationsfromentities", "String", "");
        Property property10 = new Property("generatelocationsfromlocations", "String", "");
        Property property11 = new Property("generatelocationsfromusers", "String", "");
        Property property12 = new Property("generateusersfromentities", "String", "");
        Property property13 = new Property("generateusersfromlocations", "String", "");
        Property property14 = new Property("generateusersfromusers", "String", "");
        Property property15 = new Property("userpipe", "String", "");
        Property property16 = new Property("locationpipe", "String", "");
        Property property17 = new Property("entitypipe", "String", "");
        Property property18 = new Property("pipe", "String", "");
        sensorSpec.add(property1);
        sensorSpec.add(property2);
        sensorSpec.add(property3);
        sensorSpec.add(property4);
        sensorSpec.add(property5);
        sensorSpec.add(property6);
        sensorSpec.add(property7);
        sensorSpec.add(property8);
        sensorSpec.add(property9);
        sensorSpec.add(property10);
        sensorSpec.add(property11);
        sensorSpec.add(property12);
        sensorSpec.add(property13);
        sensorSpec.add(property14);
        sensorSpec.add(property15);
        sensorSpec.add(property16);
        sensorSpec.add(property17);
        sensorSpec.add(property18);
        infrastructure.setSpecification(sensorSpec);
        return infrastructure;
    }

    public static Network createEntityFocusedNetwork(String adaptorName, String invariant) {
        Network myNetwork = AbstractApplication.createNetwork(adaptorName, "entity");
        myNetwork.task("invariant", invariant);
        return myNetwork;
    }

    public static Network createLocationFocusedNetwork(String adaptorName, String invariant) {
        Network myNetwork = AbstractApplication.createNetwork(adaptorName, "location");
        myNetwork.task("invariant", invariant);
        return myNetwork;
    }

    public static Network createUserFocusedNetwork(String adaptorName, String invariant) {
        Network myNetwork = AbstractApplication.createNetwork(adaptorName, "user");
        myNetwork.task("invariant", invariant);
        return myNetwork;
    }

    private static Network createNetwork(String adaptorName, String baseSensor) {
        Network network = new Network(adaptorName, baseSensor);
        AbstractApplication.addSensorToQueue(adaptorName, network);
        String xmlCreateString = "<createNetwork><networkType>" + adaptorName + "</networkType><SensorType>" + baseSensor + "</SensorType></createNetwork>";
        SensorSpecification sensorSpec = DiscoveryReceiver.createSensor(xmlCreateString, adaptorName, baseSensor);
        Property property2 = new Property("generateentitysensors", "boolean", "");
        Property property3 = new Property("generatelocationsensors", "boolean", "");
        Property property4 = new Property("generateusersensors", "boolean", "");
        Property property5 = new Property("invariant", "String", "");
        Property property7 = new Property("state", "boolean", "");
        Property property15 = new Property("userpipe", "String", "");
        Property property16 = new Property("locationpipe", "String", "");
        Property property17 = new Property("entitypipe", "String", "");
        Property property18 = new Property("pipe", "String", "");
        sensorSpec.add(property2);
        sensorSpec.add(property3);
        sensorSpec.add(property4);
        sensorSpec.add(property5);
        sensorSpec.add(property7);
        sensorSpec.add(property15);
        sensorSpec.add(property16);
        sensorSpec.add(property17);
        sensorSpec.add(property18);
        network.setSpecification(sensorSpec);
        return network;
    }

    public static Sensor createEntitySensor(String adaptorName) {
        return AbstractApplication.createSensor(adaptorName, "entity");
    }

    public static Sensor createLocationSensor(String adaptorName) {
        return AbstractApplication.createSensor(adaptorName, "location");
    }

    public static Sensor createUserSensor(String adaptorName) {
        return AbstractApplication.createSensor(adaptorName, "user");
    }

    public static Sensor createSensor(String adaptorName, String sensorType) {
        logger.info("trying to create sensor: " + adaptorName + "." + sensorType);
        Sensor sensor = new Sensor(adaptorName, sensorType);
        AbstractApplication.addSensorToQueue(adaptorName, sensor);
        String xmlCreateString = "<createSensor><sensorType>" + adaptorName + "</sensorType><serviceType>" + sensorType + "</serviceType></createSensor>";
        logger.info("sending retasking message: " + xmlCreateString);
        SensorSpecification sensorSpec = DiscoveryReceiver.createSensor(xmlCreateString, adaptorName, sensorType);
        if (sensorSpec == null) {
            System.err.println("could not create sensorType [ " + sensorType + " ] for adaptor [: " + adaptorName + " ]");
            System.err.println("Please check what sensor types this adaptor supports:");
            DiscoveryReceiver.printInfrastructure();
            System.exit(0);
        }
        logger.info("received sensor spec: " + sensorSpec);
        sensor.setSpecification(sensorSpec);
        return sensor;
    }

    protected static void setSensorNetworkID(String adaptorName, String type, int sensorID, String networkID) {
        AbstractApplication.setSensorID(adaptorName, type, sensorID);
        int networkIDint = Integer.parseInt(networkID);
        if (networkIDint == sensorID && !networkMap.containsKey(networkID)) {
            networkMap.put(networkIDint, (Network)sensorMap.get(networkID));
        }
        AbstractApplication.addSensorToNetwork(sensorID, networkIDint);
    }

    protected static void setSensorInfrastructureID(String adaptorName, String type, int sensorID, String infrastructureID) {
        AbstractApplication.setSensorID(adaptorName, type, sensorID);
        int infrastructureIDint = Integer.parseInt(infrastructureID);
        if (infrastructureIDint == sensorID && !networkMap.containsKey(infrastructureID)) {
            networkMap.put(infrastructureIDint, (Network)sensorMap.get(infrastructureID));
        }
        AbstractApplication.addSensorToInfrastructure(sensorID, infrastructureIDint);
    }

    private static synchronized void addSensorToInfrastructure(int sensorID, int infrastructureID) {
        if (sensorID != infrastructureID) {
            if (infrastructureSensorsMap.containsKey(infrastructureID)) {
                if (infrastructureSensorsMap.get(infrastructureID).contains(sensorID)) {
                    return;
                }
                infrastructureSensorsMap.get(infrastructureID).add(sensorID);
            } else {
                ArrayList<Integer> sensorIDList = new ArrayList<Integer>();
                sensorIDList.add(sensorID);
                infrastructureSensorsMap.put(infrastructureID, sensorIDList);
            }
        }
    }

    private static synchronized void addSensorToNetwork(int sensorID, int networkID) {
        if (sensorID != networkID) {
            if (networkSensorsMap.containsKey(networkID)) {
                if (networkSensorsMap.get(networkID).contains(sensorID)) {
                    return;
                }
                networkSensorsMap.get(networkID).add(sensorID);
            } else {
                ArrayList<Integer> sensorIDList = new ArrayList<Integer>();
                sensorIDList.add(sensorID);
                networkSensorsMap.put(networkID, sensorIDList);
            }
        }
    }

    protected static void setSensorID(String adaptorName, String sensorType, int sensorID) {
        Queue<Sensor> q;
        if (sensorQueueMap.containsKey(adaptorName) && !(q = sensorQueueMap.get(adaptorName)).isEmpty()) {
            Sensor sensor = sensorQueueMap.get(adaptorName).poll();
            sensor.setID(sensorID);
            sensorMap.put(sensorID, sensor);
        }
    }

    public static Pipe createFuserPipe(String adaptorName, String serviceName) {
        return AbstractApplication.createPipe(adaptorName, "fuser", serviceName);
    }

    protected static Pipe createPipe(String adaptorName, String pipeType, String serviceName) {
        Pipe pipe = new Pipe(adaptorName, pipeType);
        AbstractApplication.addPipeToQueue(adaptorName, pipe);
        String xmlCreateString = "<createPipe><serviceType>" + adaptorName + "</serviceType><pipeType>" + pipeType + "</pipeType>" + "<serviceName>" + serviceName + "</serviceName></createPipe>";
        SensorSpecification pipeSpec = DiscoveryReceiver.createPipe(xmlCreateString, adaptorName, pipeType, serviceName);
        pipe.setSpecification(pipeSpec);
        if (serviceName.equalsIgnoreCase("Twitter_KloutScore")) {
            pipe.task("modality", "twitter.user.screenName");
        }
        if (serviceName.equalsIgnoreCase("sentiment")) {
            pipe.task("modality", "twitter.text");
        }
        return pipe;
    }

    protected static void setPipeID(String adaptorName, String pipeType, int pipeID) {
        Queue<Pipe> q;
        if (pipeQueueMap.containsKey(adaptorName) && !(q = pipeQueueMap.get(adaptorName)).isEmpty()) {
            Pipe pipe = pipeQueueMap.get(adaptorName).poll();
            pipe.setID(pipeID);
            pipeMap.put(pipeID, pipe);
        }
    }

    public void receive(ISensorData data) {
        Object pipe;
        if (this.dataExplorer) {
            if (demo == null) {
                demo = new Dashboard("SIXTH Data Explorer", null);
            }
            this.addDataToExplorer(data);
        }
        int id = data.getID();
        String readingType = data.getReadingType();
        String value = data.getValue();
        String adaptorName = data.getNetwork();
        if (readingType.equalsIgnoreCase("New") && value.equalsIgnoreCase("pipe created") && pipeQueueMap.containsKey(adaptorName) && (pipe = pipeQueueMap.get(adaptorName).poll()) != null) {
            ((Pipe)pipe).setID(id);
        }
        if (!networkMap.containsKey(id)) {
            pipe = networkSensorsMap.keySet().iterator();
            while (pipe.hasNext()) {
                pipe.next();
            }
        }
        if (sensorMap.containsKey(id)) {
            Sensor sensor = sensorMap.get(id);
            this.respondToData(sensor, data);
        } else {
            this.respondToData(null, data);
        }
    }

    private static synchronized void addSensorToQueue(String adaptorName, Sensor sensor) {
        if (sensorQueueMap == null) {
            sensorQueueMap = new HashMap<String, Queue<Sensor>>();
        }
        if (!sensorQueueMap.containsKey(adaptorName)) {
            LinkedList<Sensor> sensorQueue = new LinkedList<Sensor>();
            sensorQueue.add(sensor);
            sensorQueueMap.put(adaptorName, sensorQueue);
        } else {
            sensorQueueMap.get(adaptorName).add(sensor);
        }
    }

    private static synchronized void addPipeToQueue(String adaptorName, Pipe pipe) {
        if (pipeQueueMap == null) {
            pipeQueueMap = new HashMap<String, Queue<Pipe>>();
        }
        if (!pipeQueueMap.containsKey(adaptorName)) {
            LinkedList<Pipe> pipeQueue = new LinkedList<Pipe>();
            pipeQueue.add(pipe);
            pipeQueueMap.put(adaptorName, pipeQueue);
        } else {
            pipeQueueMap.get(adaptorName).add(pipe);
        }
    }

    public static void printAvailableInfrastructure() {
        DiscoveryReceiver.printInfrastructure();
    }

    public Map<String, Frequency> getRequirements(NodeDescription desc) {
        return null;
    }

    public String getCredentials() {
        return null;
    }

    public void unregister() {
    }

    protected void addDataToExplorer(ISensorData data) {
        String latitudeString = "";
        String longitudeString = "";
        String networkType = data.getNetwork();
        String sensedModality = data.getSensedModality();
        Color markerColour = this.modalityColourMap.containsKey(sensedModality) ? this.modalityColourMap.get(sensedModality) : this.generateUniqueColour(sensedModality);
        Map dataMap = data.getValues();
        Set modalitySet = dataMap.keySet();
        String valuesForPrinting = "";
        for (String string : modalitySet) {
            valuesForPrinting = String.valueOf(valuesForPrinting) + (String)dataMap.get(string) + ", ";
            if (string.equalsIgnoreCase("latitude") || string.equalsIgnoreCase("lat") || string.endsWith("latitude") || string.endsWith(".lat")) {
                latitudeString = (String)dataMap.get(string);
            }
            if (!string.equalsIgnoreCase("longitude") && !string.equalsIgnoreCase("lon") && !string.endsWith("longitude") && !string.endsWith(".lon")) continue;
            longitudeString = (String)dataMap.get(string);
        }
        if (!latitudeString.isEmpty()) {
            try {
                Double latitude = Double.parseDouble(latitudeString);
                Double longitude = Double.parseDouble(longitudeString);
                demo.addExternalMapMarker(markerColour, latitude, longitude);
                String dataString = "received " + sensedModality + " data from network " + networkType + " and sensor ID " + data.getID() + ": " + valuesForPrinting;
                demo.addData(dataString);
            }
            catch (NumberFormatException e) {
                System.err.println(e);
                System.out.println("crapped out trying to parse latlong: " + latitudeString + "," + longitudeString);
                System.exit(0);
            }
        } else if (dataMap.containsKey("geoLocation")) {
            ((String)dataMap.get("geoLocation")).isEmpty();
        }
    }

    protected void launchDataExplorer() {
        this.dataExplorer = true;
        new Dashboard("", null);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Dashboard.createAndShowGUI();
            }
        });
    }

    private Color generateUniqueColour(String sensedModality) {
        Random rand = new Random();
        float r = rand.nextFloat();
        float g = rand.nextFloat();
        float b = rand.nextFloat();
        Color randomColor = new Color(r, g, b);
        this.modalityColourMap.put(sensedModality, randomColor);
        return randomColor;
    }

    protected synchronized Map<Integer, Sensor> getSensorMap() {
        return sensorMap;
    }

    protected void printSensorMap() {
        Map<Integer, Sensor> localMap = this.getSensorMap();
        for (Integer sensorID : localMap.keySet()) {
            localMap.get(sensorID).printProperties();
        }
    }

    protected static boolean sendRetask(String currentConfiguration, String adaptorName) {
        return DiscoveryReceiver.sendRetask(currentConfiguration, adaptorName);
    }
}

