/*
 * Decompiled with CFR 0.152.
 */
package application;

import buildingblocks.AbstractApplication;
import buildingblocks.Pipe;
import buildingblocks.Sensor;
import ie.ucd.sixth.core.sensor.data.ISensorData;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;

public class TwitterUserMonitoringApplication
extends AbstractApplication {
    private List<Integer> userIDs;

    public TwitterUserMonitoringApplication(BundleContext context) {
        super(context);
    }

    public TwitterUserMonitoringApplication(BundleContext context, List<Integer> userids) {
        super(context);
        this.userIDs = userids;
    }

    @Override
    protected void setup() {
        if (this.userIDs != null) {
            for (Integer id : this.userIDs) {
                Sensor twitterUserSensor = TwitterUserMonitoringApplication.createUserSensor("twitter");
                twitterUserSensor.task("" + id);
                twitterUserSensor.start();
            }
        }
    }

    @Override
    public void respondToData(Sensor sensor, ISensorData data) {
        if (sensor.getSensorType().equalsIgnoreCase("user")) {
            Pipe kloutPipe = this.createUserAggregatorPipe("klout", "kloutScore");
            Pipe sentimentPipe = this.createEntityAggregatorPipe("alchemy", "sentiment");
            Pipe kloutSummaryPipe = TwitterUserMonitoringApplication.createPipe("basic", "summary", "numeric");
            kloutSummaryPipe.task("modality", "klout.score");
            Pipe sentimentSummaryPipe = TwitterUserMonitoringApplication.createPipe("basic", "summary", "entity");
            sentimentSummaryPipe.task("modality", "sentiment");
            Pipe userCreatorPipe = TwitterUserMonitoringApplication.createPipe("basic", "sensorcreator", "user");
            ArrayList<Pipe> pipeline = new ArrayList<Pipe>();
            pipeline.add(kloutPipe);
            pipeline.add(kloutSummaryPipe);
            pipeline.add(sentimentPipe);
            pipeline.add(sentimentSummaryPipe);
            pipeline.add(userCreatorPipe);
            sensor.applyPipeLine(pipeline);
            sensor.start();
        }
    }
}

