/*
 * Decompiled with CFR 0.152.
 */
package application;

import buildingblocks.AbstractApplication;
import buildingblocks.Pipe;
import buildingblocks.Sensor;
import ie.ucd.sixth.core.sensor.data.ISensorData;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;

public class TwitterExpertMonitoringApplication
extends AbstractApplication {
    private List<Integer> userIDs;

    public TwitterExpertMonitoringApplication(BundleContext context) {
        super(context);
    }

    public TwitterExpertMonitoringApplication(BundleContext context, List<Integer> userids) {
        super(context);
        this.userIDs = userids;
    }

    @Override
    protected void setup() {
        if (this.userIDs != null) {
            for (Integer id : this.userIDs) {
                Sensor twitterUserSensor = TwitterExpertMonitoringApplication.createUserSensor("twitter");
                twitterUserSensor.task("" + id);
                twitterUserSensor.start();
            }
        }
    }

    @Override
    public void respondToData(Sensor sensor, ISensorData data) {
        if (sensor.getSensorType().equalsIgnoreCase("user")) {
            Pipe kloutScorePipe = this.createUserAggregatorPipe("klout", "kloutScore");
            Pipe kloutTopicPipe = this.createUserAggregatorPipe("klout", "klouttopic");
            Pipe tweetSummaryPipe = TwitterExpertMonitoringApplication.createPipe("basic", "summary", "entity");
            Pipe kloutSummaryPipe = TwitterExpertMonitoringApplication.createPipe("basic", "summary", "numeric");
            kloutSummaryPipe.task("modality", "klout.score");
            Pipe tweetFilterPipe = TwitterExpertMonitoringApplication.createPipe("basic", "filter", "entity");
            tweetFilterPipe.task("modalitycontainedin", "klout.topic");
            Pipe sentimentPipe = this.createEntityAggregatorPipe("alchemy", "sentiment");
            Pipe sentimentSummaryPipe = TwitterExpertMonitoringApplication.createPipe("basic", "summary", "entity");
            sentimentSummaryPipe.task("modality", "sentiment");
            ArrayList<Pipe> pipeline = new ArrayList<Pipe>();
            pipeline.add(kloutScorePipe);
            pipeline.add(kloutTopicPipe);
            pipeline.add(tweetSummaryPipe);
            pipeline.add(kloutSummaryPipe);
            pipeline.add(tweetFilterPipe);
            pipeline.add(sentimentPipe);
            pipeline.add(sentimentSummaryPipe);
            sensor.applyPipeLine(pipeline);
            sensor.start();
        }
    }
}

