/*
 * Decompiled with CFR 0.152.
 */
package application;

import buildingblocks.AbstractApplication;
import buildingblocks.Pipe;
import buildingblocks.Sensor;
import ie.ucd.sixth.core.sensor.data.ISensorData;
import java.util.ArrayList;
import org.osgi.framework.BundleContext;

public class TwitterEntityExpertCurator
extends AbstractApplication {
    private String[] topics;

    public TwitterEntityExpertCurator(BundleContext context, String[] topics) {
        super(context);
        this.topics = topics;
    }

    @Override
    protected void setup() {
        String topicString = "";
        String[] stringArray = this.topics;
        int n = this.topics.length;
        int n2 = 0;
        while (n2 < n) {
            String topic = stringArray[n2];
            topicString = String.valueOf(topicString) + topic + ";";
            ++n2;
        }
        if (topicString.endsWith(";")) {
            // empty if block
        }
        topicString = topicString.substring(0, topicString.length() - 1);
        Sensor twitterSensor = TwitterEntityExpertCurator.createEntitySensor("twitter");
        twitterSensor.task(topicString);
        Pipe userKloutTopics = this.createUserAggregatorPipe("klout", "klouttopics");
        Pipe topicFilter = TwitterEntityExpertCurator.createPipe("basic", "filter", "entity");
        topicFilter.task("modality", "klouttopics");
        topicFilter.task("modalitycontains", "olympics");
        Pipe userCreatorPipe = TwitterEntityExpertCurator.createPipe("basic", "sensorcreator", "user");
        Pipe connectedUserKloutTopics = this.createUserAggregatorPipe("klout", "klouttopics");
        connectedUserKloutTopics.task("modality", "twitter.mentions.screenname");
        Pipe connectedUserTopicFilter = TwitterEntityExpertCurator.createPipe("basic", "filter", "entity");
        connectedUserTopicFilter.task("modality", "klouttopics");
        connectedUserTopicFilter.task("modalitycontains", "olympics");
        Pipe connectedUserCreatorPipe = TwitterEntityExpertCurator.createPipe("basic", "sensorcreator", "user");
        connectedUserCreatorPipe.task("modality", "twitter.mentions.id");
        ArrayList<Pipe> pipeline = new ArrayList<Pipe>();
        pipeline.add(userKloutTopics);
        pipeline.add(topicFilter);
        pipeline.add(userCreatorPipe);
        pipeline.add(connectedUserKloutTopics);
        pipeline.add(connectedUserTopicFilter);
        pipeline.add(connectedUserCreatorPipe);
        twitterSensor.start();
    }

    @Override
    public void respondToData(Sensor sensor, ISensorData data) {
    }
}

