/*
 * Decompiled with CFR 0.152.
 */
package application;

import buildingblocks.AbstractApplication;
import buildingblocks.Pipe;
import buildingblocks.Sensor;
import ie.ucd.sixth.core.sensor.data.ISensorData;
import java.util.ArrayList;
import org.osgi.framework.BundleContext;

public class EntityMonitoringApplication
extends AbstractApplication {
    private String[] keywords;

    public EntityMonitoringApplication(BundleContext context, String[] keywords) {
        super(context);
        this.keywords = keywords;
    }

    @Override
    protected void setup() {
        Sensor facebookSensor = EntityMonitoringApplication.createEntitySensor("facebook");
        Sensor twitterSensor = EntityMonitoringApplication.createEntitySensor("twitter");
        String keywordString = "";
        String[] stringArray = this.keywords;
        int n = this.keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            keywordString = String.valueOf(keywordString) + keyword + ";";
            ++n2;
        }
        if (keywordString.endsWith(";")) {
            keywordString.substring(0, keywordString.length() - 1);
        }
        facebookSensor.task(keywordString);
        twitterSensor.task(keywordString);
        Pipe facebookSentimentPipe = this.createEntityPipe("alchemy", "aggregator", "sentiment");
        Pipe facebookSummaryPipe = this.createEntityPipe("basic", "summary", "");
        ArrayList<Pipe> pipeline = new ArrayList<Pipe>();
        pipeline.add(facebookSentimentPipe);
        pipeline.add(facebookSummaryPipe);
        facebookSensor.applyPipeLine(pipeline);
        Pipe twitterSentimentPipe = this.createEntityPipe("alchemy", "aggregator", "sentiment");
        Pipe twitterSummaryPipe = this.createEntityPipe("basic", "summary", "");
        Pipe userCreatorPipe = EntityMonitoringApplication.createPipe("basic", "sensorcreator", "user");
        new ArrayList();
        pipeline.add(twitterSentimentPipe);
        pipeline.add(twitterSummaryPipe);
        pipeline.add(userCreatorPipe);
        twitterSensor.applyPipeLine(pipeline);
        facebookSensor.start();
        twitterSensor.start();
    }

    @Override
    public void respondToData(Sensor sensor, ISensorData data) {
    }
}

