/*
 * Decompiled with CFR 0.152.
 */
package application;

import ie.ucd.sixth.core.cyber.utils.geocode.Geocoder;
import ie.ucd.sixth.core.sensor.data.SensorData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;

public class Cobweb_Utils {
    String myDriver = "org.gjt.mm.mysql.Driver";
    String myUrl = "jdbc:mysql://localhost/SIXTH_Cobweb";
    private static Connection conn;

    public Cobweb_Utils() {
        try {
            Class.forName(this.myDriver);
            conn = DriverManager.getConnection(this.myUrl, "root", "");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    protected synchronized void updateCobWebDatabase(int sensorID, String sensedModality, String networkType, String invariant, String variant, SensorData data, double latitude, double longitude) {
        String query = " insert into data (`sensorid`, `sensedmodality`, `networktype`, `sensordata`, `invariant`, `variant`, `latitude`, `longitude`) values (?, ?, ?, ?, ?, ?, ?, ?)";
        try {
            PreparedStatement preparedStmt = conn.prepareStatement(query);
            preparedStmt.setInt(1, sensorID);
            preparedStmt.setString(2, sensedModality);
            preparedStmt.setString(3, networkType);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(data);
            byte[] dataAsBytes = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(dataAsBytes);
            preparedStmt.setBinaryStream(4, (InputStream)bais, dataAsBytes.length);
            preparedStmt.setString(5, invariant);
            preparedStmt.setString(6, variant);
            preparedStmt.setDouble(7, latitude);
            preparedStmt.setDouble(8, longitude);
            preparedStmt.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static synchronized void shutdownDatabase() {
        try {
            conn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Map locationMap = Geocoder.geocode((String)"europe");
        String boundingboxpath = "searchresults.place.0.boundingbox";
        String latitudepath = "searchresults.place.0.lat";
        String longitudepath = "searchresults.place.0.lon";
        System.out.println((String)locationMap.get(latitudepath));
        System.out.println((String)locationMap.get(longitudepath));
        System.out.println((String)locationMap.get(boundingboxpath));
    }
}

