/*
 * Decompiled with CFR 0.152.
 */
package application;

import buildingblocks.AbstractApplication;
import buildingblocks.Infrastructure;
import buildingblocks.Sensor;
import ie.ucd.sixth.core.cyber.adaptor.sensor.AbstractAdaptorStream;
import ie.ucd.sixth.core.cyber.utils.geocode.Geocoder;
import ie.ucd.sixth.core.sensor.data.ISensorData;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;

public class App_Flooding
extends AbstractApplication {
    private final String TSTR = "flood";
    private final String NA = "data.nearest_area.";
    private final String LT = "latitude";
    private final String LN = "longitude";
    private final String NALT = "data.nearest_area.latitude";
    private final String NALN = "data.nearest_area.longitude";
    private final String TDOT = "twitter.";
    private final String TLT = "twitter.latitude";
    private final String TLN = "twitter.longitude";
    private final String TLOC = "twitter.user.userLocation";
    private final String SLT = "searchresults.place.0.lat";
    private final String SLN = "searchresults.place.0.lon";
    private final String TEXT = "text";
    private final String TTEXT = "twitter.text";
    private static Logger logger = Logger.getLogger(AbstractAdaptorStream.class.getName());

    static {
        logger.setLevel(Level.ALL);
    }

    public App_Flooding(BundleContext context) {
        super(context);
    }

    @Override
    protected void setup() {
        Infrastructure twitterInfrastructure = App_Flooding.createEntityFocusedInfrastructure("twitter", "flood");
        twitterInfrastructure.start();
    }

    @Override
    public void respondToData(Sensor sensor, ISensorData data) {
        Map map = data.getValues();
        Set ks = map.keySet();
        String lat = null;
        if (ks.contains("data.nearest_area.latitude")) {
            lat = (String)map.get("data.nearest_area.latitude");
            String cfr_ignored_0 = (String)map.get("data.nearest_area.longitude");
        } else if (ks.contains("twitter.latitude")) {
            lat = (String)map.get("twitter.latitude");
            String cfr_ignored_1 = (String)map.get("twitter.longitude");
        } else {
            String locationNameValue = (String)data.getValues().get("twitter.user.userLocation");
            if (locationNameValue != null) {
                Map coords = Geocoder.geocode((String)locationNameValue);
                lat = (String)coords.get("searchresults.place.0.lat");
                String cfr_ignored_2 = (String)coords.get("searchresults.place.0.lon");
            }
        }
        if (lat != null) {
            String tweet = (String)map.get("twitter.text");
            logger.info("Inserting tweet: " + tweet);
        }
    }
}

