/*
 * Decompiled with CFR 0.152.
 */
package application;

import buildingblocks.AbstractApplication;
import buildingblocks.Infrastructure;
import buildingblocks.Sensor;
import dashboard.SplitViewFrame;
import ie.ucd.sixth.core.cyber.utils.geocode.Geocoder;
import ie.ucd.sixth.core.sensor.data.ISensorData;
import ie.ucd.sixth.core.sensor.data.SensorData;
import java.awt.Color;
import java.util.Map;
import org.osgi.framework.BundleContext;

public class App_Ebola
extends AbstractApplication {
    private SplitViewFrame gui;

    public App_Ebola(BundleContext context) {
        super(context);
    }

    @Override
    protected void setup() {
        this.gui = new SplitViewFrame();
        this.gui.setup();
        Infrastructure twitterInfrastructure = App_Ebola.createEntityFocusedInfrastructure("twitter", "ebola");
        twitterInfrastructure.generateLocations("worldweather");
        twitterInfrastructure.generateUsers();
        twitterInfrastructure.start();
    }

    @Override
    public void respondToData(Sensor sensor, ISensorData data) {
        block39: {
            SensorData cfr_ignored_0 = (SensorData)data;
            if (data.getValues().containsKey("data.nearest_area.latitude")) {
                if (data.getValues().containsKey("data.nearest_area.longitude")) {
                    String latString = (String)data.getValues().get("data.nearest_area.latitude");
                    String lonString = (String)data.getValues().get("data.nearest_area.longitude");
                    Double lat = Double.parseDouble(latString);
                    Double lon = Double.parseDouble(lonString);
                    SplitViewFrame.addLocationDataCircle(Color.BLUE, lat, lon);
                    SplitViewFrame.addListData("weather location: " + lat + "," + lon + ": " + data.getValues().toString());
                }
            } else if (data.getValues().containsKey("twitter.latitude")) {
                if (data.getValues().containsKey("twitter.longitude")) {
                    String latString = (String)data.getValues().get("twitter.latitude");
                    String lonString = (String)data.getValues().get("twitter.longitude");
                    Double lat = Double.parseDouble(latString);
                    Double lon = Double.parseDouble(lonString);
                    if (data.getSensedModality().startsWith("entity")) {
                        SplitViewFrame.addLocationDataRectangle(Color.GREEN, lat, lon);
                        SplitViewFrame.addListData("twitter entity: ebola location:" + lat + "," + lon + ": " + data.getValues().toString());
                    } else if (data.getSensedModality().startsWith("user")) {
                        SplitViewFrame.addLocationDataRectangle(Color.RED, lat, lon);
                        SplitViewFrame.addListData("twitter user: ebola location: " + lat + "," + lon + ": " + data.getValues().toString());
                    }
                }
            } else if (data.getValues().containsKey("twitter.user.userLocation") && !((String)data.getValues().get("twitter.user.userLocation")).isEmpty()) {
                String locationNameValue = (String)data.getValues().get("twitter.user.userLocation");
                System.out.println("location name: " + locationNameValue);
                if (locationNameValue != null && !locationNameValue.isEmpty()) {
                    try {
                        Map coords = Geocoder.geocode((String)locationNameValue);
                        if (coords.containsKey("searchresults.place.0.lat")) {
                            String latString = (String)coords.get("searchresults.place.0.lat");
                            String lonString = (String)coords.get("searchresults.place.0.lon");
                            System.out.println(latString);
                            System.out.println(lonString);
                            System.out.println(coords.toString());
                            try {
                                Double lat = Double.parseDouble(latString);
                                Double lon = Double.parseDouble(lonString);
                                if (data.getSensedModality().startsWith("entity")) {
                                    SplitViewFrame.addLocationDataRectangle(Color.GREEN, lat, lon);
                                    SplitViewFrame.addListData("twitter entity: ebola location:" + lat + "," + lon + ": " + data.getValues().toString());
                                } else if (data.getSensedModality().startsWith("user")) {
                                    SplitViewFrame.addLocationDataRectangle(Color.RED, lat, lon);
                                    SplitViewFrame.addListData("twitter user: ebola location: " + lat + "," + lon + ": " + data.getValues().toString());
                                }
                                break block39;
                            }
                            catch (Exception exception) {
                                if (data.getSensedModality().startsWith("entity")) {
                                    SplitViewFrame.addListData("[location unknown] [network type: " + data.getNetwork() + " ] [sensor: " + data.getID() + ":" + data.getSensedModality() + "]  [values: " + data.getValues() + "]");
                                } else if (data.getSensedModality().startsWith("user")) {
                                    SplitViewFrame.addListData("[location unknown] [network type: " + data.getNetwork() + " ] [sensor: " + data.getID() + ":" + data.getSensedModality() + "]  [values: " + data.getValues() + "]");
                                }
                                break block39;
                            }
                        }
                        if (!coords.containsKey("searchresults.place.lat")) break block39;
                        String latString = (String)coords.get("searchresults.place.lat");
                        String lonString = (String)coords.get("searchresults.place.lon");
                        try {
                            Double lat = Double.parseDouble(latString);
                            Double lon = Double.parseDouble(lonString);
                            if (data.getSensedModality().startsWith("entity")) {
                                SplitViewFrame.addLocationDataRectangle(Color.GREEN, lat, lon);
                                SplitViewFrame.addListData("twitter entity: ebola location:" + lat + "," + lon + ": " + data.getValues().toString());
                            } else if (data.getSensedModality().startsWith("user")) {
                                SplitViewFrame.addLocationDataRectangle(Color.RED, lat, lon);
                                SplitViewFrame.addListData("twitter user: ebola location: " + lat + "," + lon + ": " + data.getValues().toString());
                            }
                        }
                        catch (Exception exception) {
                            if (data.getSensedModality().startsWith("entity")) {
                                SplitViewFrame.addListData("[location unknown] [network type: " + data.getNetwork() + " ] [sensor: " + data.getID() + ":" + data.getSensedModality() + "]  [values: " + data.getValues() + "]");
                            } else if (data.getSensedModality().startsWith("user")) {
                                SplitViewFrame.addListData("[location unknown] [network type: " + data.getNetwork() + " ] [sensor: " + data.getID() + ":" + data.getSensedModality() + "]  [values: " + data.getValues() + "]");
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (data.getSensedModality().startsWith("entity")) {
                            SplitViewFrame.addListData("[location unknown] [network type: " + data.getNetwork() + " ] [sensor: " + data.getID() + ":" + data.getSensedModality() + "]  [values: " + data.getValues() + "]");
                        } else if (data.getSensedModality().startsWith("user")) {
                            SplitViewFrame.addListData("[location unknown] [network type: " + data.getNetwork() + " ] [sensor: " + data.getID() + ":" + data.getSensedModality() + "]  [values: " + data.getValues() + "]");
                        }
                    }
                }
            } else if (data.getNetwork().equalsIgnoreCase("twitter") && data.getSensedModality().startsWith("entity")) {
                SplitViewFrame.addListData("[location unknown] [network type: " + data.getNetwork() + " ] [sensor: " + data.getID() + ":" + data.getSensedModality() + "]  [values: " + data.getValues() + "]");
            } else if (data.getNetwork().equalsIgnoreCase("twitter") && data.getSensedModality().startsWith("user")) {
                SplitViewFrame.addListData("[location unknown] [network type: " + data.getNetwork() + " ] [sensor: " + data.getID() + ":" + data.getSensedModality() + "]  [values: " + data.getValues() + "]");
            } else if (data.getSensedModality().endsWith("notification")) {
                SplitViewFrame.addListData(String.valueOf(data.getSensedModality()) + "... " + data.getValues().toString());
            }
        }
    }
}

