/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.Cobweb_Utils;
import buildingblocks.AbstractApplication;
import buildingblocks.Sensor;
import dashboard.SplitViewFrame;
import ie.ucd.sixth.core.cyber.utils.geocode.BoundingBox;
import ie.ucd.sixth.core.cyber.utils.geocode.Geocoder;
import ie.ucd.sixth.core.sensor.data.ISensorData;
import ie.ucd.sixth.core.sensor.data.SensorData;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;
import org.osgi.framework.BundleContext;

public class App_Cobweb
extends AbstractApplication {
    private SplitViewFrame gui;
    private Cobweb_Utils utils;
    private BoundingBox b = new BoundingBox("-14.0155169,49.674,2.0919117,61.061");

    public App_Cobweb(BundleContext context) {
        super(context);
    }

    @Override
    protected void setup() {
        this.gui = new SplitViewFrame();
        this.gui.setup();
        Sensor twitterSensor = App_Cobweb.createLocationSensor("twitter");
        twitterSensor.task("-180,-90,180,90");
        twitterSensor.start();
        Sensor twitterEntitySensor = App_Cobweb.createEntitySensor("twitter");
        twitterEntitySensor.task("weather");
        twitterEntitySensor.start();
    }

    @Override
    public void respondToData(Sensor sensor, ISensorData data) {
        block26: {
            SensorData cfr_ignored_0 = (SensorData)data;
            new ArrayList();
            if (data.getValues().containsKey("a.Center.Latitude")) {
                if (data.getValues().containsKey("a.Center.Longitude")) {
                    String latString = (String)data.getValues().get("a.Center.Latitude");
                    String lonString = (String)data.getValues().get("a.Center.Longitude");
                    Double lat = Double.parseDouble(latString);
                    Double lon = Double.parseDouble(lonString);
                    SplitViewFrame.addLocationDataCircle(Color.RED, lat, lon);
                    SplitViewFrame.addListData("flood location: " + lat + "," + lon + ": " + data.getValues().toString());
                }
            } else if (data.getValues().containsKey("a.latitude")) {
                if (data.getValues().containsKey("a.longitude")) {
                    String latString = (String)data.getValues().get("a.latitude");
                    String lonString = (String)data.getValues().get("a.longitude");
                    Double lat = Double.parseDouble(latString);
                    Double lon = Double.parseDouble(lonString);
                    SplitViewFrame.addLocationDataCircle(Color.BLUE, lat, lon);
                    SplitViewFrame.addListData("river levels location: " + lat + "," + lon + ": " + data.getValues().toString());
                }
            } else if (data.getValues().containsKey("data.nearest_area.latitude")) {
                if (data.getValues().containsKey("data.nearest_area.longitude")) {
                    String latString = (String)data.getValues().get("data.nearest_area.latitude");
                    String lonString = (String)data.getValues().get("data.nearest_area.longitude");
                    Double lat = Double.parseDouble(latString);
                    Double lon = Double.parseDouble(lonString);
                    SplitViewFrame.addLocationDataCircle(Color.GREEN, lat, lon);
                    SplitViewFrame.addListData("weather location: " + lat + "," + lon + ": " + data.getValues().toString());
                }
            } else if (data.getValues().containsKey("twitter.latitude")) {
                if (data.getValues().containsKey("twitter.longitude")) {
                    String latString = (String)data.getValues().get("twitter.latitude");
                    String lonString = (String)data.getValues().get("twitter.longitude");
                    Double lat = Double.parseDouble(latString);
                    Double lon = Double.parseDouble(lonString);
                    SplitViewFrame.addLocationDataRectangle(Color.ORANGE, lat, lon);
                    if (this.b.contains(lat.doubleValue(), lon.doubleValue())) {
                        SplitViewFrame.addListData("twitter location: " + lat + "," + lon + ": " + data.getValues().toString());
                    }
                }
            } else if (data.getValues().containsKey("twitter.user.userLocation") && !((String)data.getValues().get("twitter.user.userLocation")).isEmpty()) {
                String locationNameValue = (String)data.getValues().get("twitter.user.userLocation");
                System.out.println("location name: " + locationNameValue);
                if (locationNameValue != null && !locationNameValue.isEmpty()) {
                    try {
                        Map coords = Geocoder.geocode((String)locationNameValue);
                        if (coords.containsKey("searchresults.place.0.lat")) {
                            String latString = (String)coords.get("searchresults.place.0.lat");
                            String lonString = (String)coords.get("searchresults.place.0.lon");
                            try {
                                Double lat = Double.parseDouble(latString);
                                Double lon = Double.parseDouble(lonString);
                                SplitViewFrame.addLocationDataRectangle(Color.ORANGE, lat, lon);
                                if (this.b.contains(lat.doubleValue(), lon.doubleValue())) {
                                    SplitViewFrame.addListData("twitter location:" + lat + "," + lon + ": " + data.getValues().toString());
                                }
                                break block26;
                            }
                            catch (Exception exception) {}
                            break block26;
                        }
                        if (!coords.containsKey("searchresults.place.lat")) break block26;
                        String latString = (String)coords.get("searchresults.place.lat");
                        String lonString = (String)coords.get("searchresults.place.lon");
                        try {
                            Double lat = Double.parseDouble(latString);
                            Double lon = Double.parseDouble(lonString);
                            SplitViewFrame.addLocationDataRectangle(Color.ORANGE, lat, lon);
                            if (this.b.contains(lat.doubleValue(), lon.doubleValue())) {
                                SplitViewFrame.addListData("twitter location:" + lat + "," + lon + ": " + data.getValues().toString());
                            }
                        }
                        catch (Exception exception) {
                        }
                    }
                    catch (Exception exception) {}
                }
            } else if (data.getSensedModality().endsWith("notification")) {
                SplitViewFrame.addListData(String.valueOf(data.getSensedModality()) + "... " + data.getValues().toString());
            }
        }
    }
}

