/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.service.pipe.alchemy;

import ie.ucd.sixth.core.cyber.utils.UrlRequester;
import ie.ucd.sixth.core.cyber.utils.parsers.XmlToMapConverter;
import ie.ucd.sixth.pipe.alchemy.services.AlchemyNamedEntityExtractionInfo;
import ie.ucd.sixth.pipe.alchemy.services.Sentiment;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ResourceManager {
    private int callsPerRequest = 2;
    private int maxCallsPerSecond = 10;
    private long nanoTimeBetweenCalls = 200000000L;
    private long lastCallTime = 0L;
    private UrlRequester urlRequester = new UrlRequester();
    private XmlToMapConverter converter = new XmlToMapConverter();

    public Map<String, String> getData(String type, String modalityValue) {
        long difference = System.nanoTime() - this.getLastCallTime();
        if (difference < this.nanoTimeBetweenCalls) {
            System.out.println("waiting");
            try {
                long wait = TimeUnit.MILLISECONDS.convert(this.nanoTimeBetweenCalls - difference, TimeUnit.NANOSECONDS);
                Thread.sleep(wait);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (type.equalsIgnoreCase("sentiment")) {
            return Sentiment.getSentiment(modalityValue);
        }
        if (type.equalsIgnoreCase("EntityExtraction")) {
            return AlchemyNamedEntityExtractionInfo.namedEntityExtractionOnText(modalityValue);
        }
        return null;
    }

    private synchronized long getLastCallTime() {
        return this.lastCallTime;
    }

    private synchronized void setLastCallTime() {
        this.lastCallTime = this.lastCallTime;
    }
}

