/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.service.pipe.alchemy;

import ie.ucd.sixth.core.cyber.adaptor.pipe.AbstractPipeAdaptor;
import ie.ucd.sixth.core.cyber.adaptor.pipe.AbstractPipeFactory;
import ie.ucd.sixth.core.cyber.pipe.AbstractPipeService;
import ie.ucd.sixth.core.service.IPipeService;
import ie.ucd.sixth.service.pipe.alchemy.fusers.AlchemyNamedEntityExtractionFuser;
import ie.ucd.sixth.service.pipe.alchemy.fusers.AlchemySentimentFuser;

public class AlchemyPipeFactory
extends AbstractPipeFactory {
    private AbstractPipeAdaptor adaptor;

    public AlchemyPipeFactory(AbstractPipeAdaptor adaptor) {
        super(adaptor);
        this.adaptor = adaptor;
    }

    public IPipeService createPipe(String serviceName) {
        int id = this.generateId();
        this.adaptor.sendSensorCreationConfirmation(id, "alchemy", "fuser", serviceName);
        return this.createPipe(this.adaptor, serviceName, id);
    }

    public IPipeService createPipe(AbstractPipeAdaptor ad, String serviceName, int id) {
        System.out.println("in alchemyfactory.createPipe()");
        if (serviceName.equalsIgnoreCase("sentiment")) {
            AlchemySentimentFuser pipe = new AlchemySentimentFuser(ad, id);
            this.addPipe(id, (AbstractPipeService)pipe);
            ad.addPipeToMap(id, (AbstractPipeService)pipe);
            return pipe;
        }
        if (serviceName.equalsIgnoreCase("EntityExtraction")) {
            AlchemyNamedEntityExtractionFuser pipe = new AlchemyNamedEntityExtractionFuser(ad, id);
            this.addPipe(id, (AbstractPipeService)pipe);
            ad.addPipeToMap(id, (AbstractPipeService)pipe);
            return pipe;
        }
        if (serviceName.equalsIgnoreCase("KeywordExtraction")) {
            AlchemyNamedEntityExtractionFuser pipe = new AlchemyNamedEntityExtractionFuser(ad, id);
            this.addPipe(id, (AbstractPipeService)pipe);
            ad.addPipeToMap(id, (AbstractPipeService)pipe);
            return pipe;
        }
        return null;
    }
}

