/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.service.pipe.alchemy;

import ie.ucd.sixth.core.cyber.adaptor.pipe.AbstractPipeAdaptor;
import ie.ucd.sixth.core.cyber.adaptor.sensor.ParseSensorProperties;
import ie.ucd.sixth.core.cyber.pipe.AbstractFuserPipe;
import ie.ucd.sixth.core.discovery.ISIXTHNode;
import ie.ucd.sixth.core.service.IPipeService;
import ie.ucd.sixth.service.pipe.alchemy.AlchemyPipeFactory;
import ie.ucd.sixth.service.pipe.alchemy.ResourceManager;
import ie.ucd.sixth.service.pipe.alchemy.fusers.AlchemyKeyworkExtractionFuser;
import ie.ucd.sixth.service.pipe.alchemy.fusers.AlchemyNamedEntityExtractionFuser;
import ie.ucd.sixth.service.pipe.alchemy.fusers.AlchemySentimentFuser;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleContext;

public class AlchemyPipeAdaptor
extends AbstractPipeAdaptor {
    private static final int maxCallsPerSecond = 10;
    private static int totalCallsThisSecond = 0;
    private static long timeSinceLastCall = 0L;
    private ResourceManager resourceManager;
    private BundleContext bundleContext;

    public AlchemyPipeAdaptor(BundleContext bundleContext, String type) {
        super(bundleContext, type);
        this.bundleContext = bundleContext;
        this.factory = new AlchemyPipeFactory(this);
        this.resourceManager = new ResourceManager();
        this.registerFactory(this.factory);
    }

    protected void createPipe(String serviceName) {
        this.factory.createPipe(serviceName);
    }

    protected void configurePipe(int pipeId, ParseSensorProperties parser) {
        System.out.println("CONFIGURING PIPE: pipeId=" + pipeId);
        Map propertiesMap = parser.getPropertiesMap();
        if (propertiesMap == null || propertiesMap.isEmpty()) {
            System.out.println("no properties set");
            return;
        }
        System.out.println("properties set...");
        for (Map.Entry entry : propertiesMap.entrySet()) {
            System.out.println(String.valueOf((String)entry.getKey()) + ", " + (String)entry.getValue());
        }
        if (pipeId == 0) {
            System.out.println("pipeId could not be resolved");
            return;
        }
        System.out.println("printing the ids from the pipemap in KloutPipeAdaptor: " + this.pipeMap.size());
        Set idSet = this.pipeMap.keySet();
        for (Integer string : idSet) {
            System.out.println("id: " + string);
        }
        System.out.println("finsihed printing ids");
        if (this.pipeMap.containsKey(pipeId)) {
            AbstractFuserPipe pipe;
            System.out.println("configuring id:" + pipeId);
            String serviceName = ((IPipeService)this.pipeMap.get(pipeId)).getName();
            System.out.println("servicename: " + serviceName);
            if (serviceName.equalsIgnoreCase("sentiment")) {
                pipe = (AlchemySentimentFuser)((Object)this.pipeMap.get(pipeId));
                for (Map.Entry property : propertiesMap.entrySet()) {
                    System.out.println("AlchemySentimentFuser: setting property:" + (String)property.getKey() + ", " + (String)property.getValue());
                    pipe.setProperty((String)property.getKey(), (String)property.getValue());
                }
            } else if (serviceName.equalsIgnoreCase("EntityExtraction")) {
                pipe = (AlchemyNamedEntityExtractionFuser)((Object)this.pipeMap.get(pipeId));
                for (Map.Entry property : propertiesMap.entrySet()) {
                    System.out.println("AlchemyNamedEntityExtractionFuser: setting property:" + (String)property.getKey() + ", " + (String)property.getValue());
                    pipe.setProperty((String)property.getKey(), (String)property.getValue());
                }
            } else if (serviceName.equalsIgnoreCase("KeywordExtraction")) {
                pipe = (AlchemyKeyworkExtractionFuser)((Object)this.pipeMap.get(pipeId));
                for (Map.Entry property : propertiesMap.entrySet()) {
                    System.out.println("AlchemyKeyworkExtractionFuser: setting property:" + (String)property.getKey() + ", " + (String)property.getValue());
                    pipe.setProperty((String)property.getKey(), (String)property.getValue());
                }
            }
        } else {
            System.out.println("could not configure pipe");
        }
    }

    public void attachNode(ISIXTHNode node) {
    }

    public ISIXTHNode getNode() {
        return null;
    }

    public Map<String, String> getResource(String pipename, String modalityValue) {
        return this.resourceManager.getData(pipename, modalityValue);
    }

    public String getSpecification() {
        String sentimentDesc = "<pipe type='fuser.sentiment' id='0000000'><property name='modality' type='String' /></pipe>";
        String entityExtractionDesc = "<pipe type='fuser.EntityExtraction' id='0000000'><property name='modality' type='String' /></pipe>";
        String keywordExtractionDesc = "<pipe type='fuser.keywordExtraction' id='0000000'><property name='modality' type='String' /></pipe>";
        String spec = "<adaptorDescription name='Alchemy'>" + sentimentDesc + entityExtractionDesc + keywordExtractionDesc + "<output type='text'/></adaptorDescription>";
        return spec;
    }
}

