/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.postgresql.PGConnection;

public class TestServer {
    static /* synthetic */ Class class$org$postgis$PGgeometry;
    static /* synthetic */ Class class$org$postgis$PGbox3d;

    public static void main(String[] args) {
        if (args.length != 4 && args.length != 3) {
            System.err.println("Usage: java examples/TestServer dburl user pass [tablename]");
            System.err.println();
            System.err.println("dburl has the following format:");
            System.err.println("jdbc:postgresql://HOST:PORT/DATABASENAME");
            System.err.println("tablename is 'jdbc_test' by default.");
            System.exit(1);
        }
        String dburl = args[0];
        String dbuser = args[1];
        String dbpass = args[2];
        String dbtable = "jdbc_test";
        String dropSQL = "drop table " + dbtable;
        String createSQL = "create table " + dbtable + " (geom geometry, id int4)";
        String insertPointSQL = "insert into " + dbtable + " values ('POINT (10 10 10)',1)";
        String insertPolygonSQL = "insert into " + dbtable + " values ('POLYGON ((0 0 0,0 10 0,10 10 0,10 0 0,0 0 0))',2)";
        try {
            System.out.println("Creating JDBC connection...");
            Class.forName("org.postgresql.Driver");
            Connection conn = DriverManager.getConnection(dburl, dbuser, dbpass);
            System.out.println("Adding geometric type entries...");
            ((PGConnection)conn).addDataType("geometry", class$org$postgis$PGgeometry == null ? (class$org$postgis$PGgeometry = TestServer.class$("org.postgis.PGgeometry")) : class$org$postgis$PGgeometry);
            ((PGConnection)conn).addDataType("box3d", class$org$postgis$PGbox3d == null ? (class$org$postgis$PGbox3d = TestServer.class$("org.postgis.PGbox3d")) : class$org$postgis$PGbox3d);
            Statement s = conn.createStatement();
            System.out.println("Creating table with geometric types...");
            try {
                s.execute(dropSQL);
            }
            catch (Exception e) {
                System.out.println("Error dropping old table: " + e.getMessage());
            }
            s.execute(createSQL);
            System.out.println("Inserting point...");
            s.execute(insertPointSQL);
            System.out.println("Inserting polygon...");
            s.execute(insertPolygonSQL);
            System.out.println("Done.");
            s = conn.createStatement();
            System.out.println("Querying table...");
            ResultSet r = s.executeQuery("select asText(geom),id from " + dbtable);
            while (r.next()) {
                Object obj = r.getObject(1);
                int id = r.getInt(2);
                System.out.println("Row " + id + ":");
                System.out.println(obj.toString());
            }
            s.close();
            conn.close();
        }
        catch (Exception e) {
            System.err.println("Aborted due to error:");
            e.printStackTrace();
            System.exit(1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

